;DD50BIOS
;
; dd.exe IF=DD50BIOS.BIN OF=JadeDisk.IMG bs=128 skip=3 count=8
;
; this Jade DD bios for the Z80 Emulator supports 
;  IBM 3740 disk images(not bootable) or
;  Jade Single Sided Single Density (JadeSSSD and Jade50SSSD) disk images ( Bootable)
;  Jade Single sided Double Density (JadeSSDD and Jade50SSDD) disk images ( Bootable)
;  Jade Double Sided Single Density (Jade50DSSD) disk images ( Bootable)
;  Jade Double sided Double Density (Jade50DSDD) disk images ( Bootable)
;and partially supports
;  Psuedo Jade Single sided Double Density (JadeDD)  disk images ( not Bootable with this bios)
;
;IBM 3740 77 tracks 26 spt 128 bps(diskette 1 SS SD)
;JadeSSSD 77 tracks 26 spt on track0 and data tracks(2-76), 48 SPT on system track(t1) 128 BPS
;JadeSSDD 77 tracks 26 spt on track0, 48 SPT on system track(t1) and data tracks(2-76) 128 BPS
;Jade50SSSD 77 tracks 26 spt on track0 and data tracks(2-76), 50 SPT on system track(t1) 128 BPS
;Jade50SSDD 77 tracks 26 spt on track0, 50 SPT on system track(t1) and data tracks(2-76) 128 BPS
;Jade50DSSD 154 tracks 26 spt on track0 and data tracks(2-154), 50 SPT on system track(t1) 128 BPS
;Jade50DSDD 154 tracks 26 spt on track0, 50 SPT on system track(t1) and data tracks(2-154) 128 BPS

;JadeDD   77 tracks 48 spt on track0, system track(t1) and data tracks(2-76) 128 BPS

;WARNING- do not use old incorrect format JadeDD disk images unless you set SPT for T0 after login
;  this bios always sets T0 to 26 SPT at disk login.

;to boot...select disk image type- JadeSSSD, JadeSSDD, IBM3740 (actually any type will do ...
;  All that is required to boot is boot sector =3 , load and execution address=100)
;   and sectors 1-12 are accessible on track 0
;  the disk type will be automatically set by bios. based on ID table in sector 1

nk.sys	equ	62	;system size in  kBytes
k.byte	equ	1024	;bytes in a kilobyte
cpm.sz	equ	nk.sys*k.byte	;top system addres
v.20k	equ	20*k.byte	;twenty kByte 
cpm.bs	equ	cpm.sz-v.20k	;cpm bias value
ccp	equ	cpm.bs+&H3400	;addres of ccp
bdos	equ	cpm.bs+&H3c00	;addres of bdos
bios	equ	cpm.bs+&H4a00	;addres of bios
bios.r	equ	&H1000-bios	;DDT offset load?
tpa	equ	&H100		;addres of TPA
;iobyte	equ	&Hff		;initial iobyte value

io.byte	equ	3		;address of iobyte
c.disk	equ	4		;address of current logged disk

;un-initialized data definition

ui$data	equ	0fa00h		

df.drv	equ	0		;default drive
sec.sz	equ	&H80		;sector size
fmt.sz	EQU	&h100		;format buffer size
n.drvs	equ	4		;number of drives(1-4)

true	equ	1
false	equ	0

;Z80 Emualator hardware parameters (new Disk interface)

ndi.Lo	equ	0xC8
ndi.Hi	equ	0xC9
ndi.Sel	equ	0xCA

cmd.read	equ	1
cmd.write	equ	2

;macros for setting up NDI IO parmeter tables.

Set8	macro	?Register,?Value,?Label
	db	1,?Register
?Label	db	?Value
	endm

Set16	macro	?Register,?Value,?Label
	db	2,?Register
?Label	dw	?Value
	endm
;
	org	bios

;bios jump vector table

	jmp	init	;cold start
	jmp	warm	;warm start - reload ccp + bdos
	jmp	cns.ck	;get console status
	jmp	cns.in	;console input
	jmp	cns.ot	;console output
	jmp	list	;printer output
	jmp	punch	;punch output
	jmp	reader	;reader input
	jmp	home	;home selected drive
	jmp	seldsk	;select drive
	jmp	settrk	;set track
	jmp	setsec	;set sector
	jmp	setdma	;set tranfer address
	jmp	diskrd	;read disk
	jmp	diskwr	;write disk
	jmp	listst	;getr printer status
	jmp	sectrn	;translate sector
	jmp	format	;format a track

;bios variable storage

dt.ptr	dw	0	;drive table pointer
log.rq	db	0	;log on request

;log buffer takes the place of DD log buffer

log.dpb	equ	20h		;offset to dpb in buffer
log.ddf	equ	31h		;id sec - flags	

;init stuff is overlayed by directory buffer

dir.bf	equ	$

;get system size in ascii

init	lxi	sp,&H0080	;set initial stack
	lxi	h,cpm.sz	;get cpm size
	mov	a,h		;get number of 256 byte pages
	rrc			;/2
	rrc			;/2
	mvi	b,0		;zero tens counter
c.tens	cmpi	10		;is it 10
	jc	c.ones		;less than 10
	sui	10		;-10
	inr	b		;increment tens counter
	jmp	c.tens		;again
c.ones	adi	&H30		;ascii 0
	sta	sys.od		;store ones digit
	mov	a,b		;get tens count
	adi	&H30		;ascii 0
	sta	sys.td		;store tens digit

;system initialization

;	jmp c.logo		;jump over reserved
;	ds	25
c.logo	lxi	h,msg.so	;sign on message
	call	msg.ot		;out message
	lhld	bios+4		;get warm address
	shld	bios+1		;make cold point to warm

	xra	a		;clear accumulator
	sta	io.byte		;store at iobyte
	sta	c.disk		;current logged disk =0

	jmp	warm		;do warm boot


msg.so	db	cr,lf,cr,lf
	text	"DD50BIOS V1 for 48/50 SPT Jade Images"
	db	cr,lf
sys.td	db	&H30
sys.od	db	&H30
	text	"K CP/M VERS 2.2 "
	db	cr,lf,cr,lf+&H80	;sign bit set on last byte

;fill out directory buffer dir.buf if needed

eoOVER	equ	$	;end of OVER lay stuff

	if eoOVER lt (dir.bf+80h)
	org	dir.bf+80h
	endif

;read sector

diskrd:
	mvi	a,cmd.read
	sta	bt.cmd
	call	dsk.ex		;perform operation
	jz	dsk.ok		;normal exit
	jmp	dsk.er		;exit error

;write sector

diskwr:	
	mvi	a,cmd.write
	sta	bt.cmd
	call	dsk.ex		;perform operation
	jz	dsk.ok		;normal exit if write ok
	jmp	dsk.er		;exit error

;disk read write format exits and errors

dsk.ok:	
	xra	a		;clear a to indicate OK
	ret

dsk.er:	
	mvi	a,0FFh		;set a to indicate ERROR
	ret


format	
	jmp	dsk.ok		; claim it worked even though not done

; load this to select drv (done separate to allow 1.0.18 - 1.0 22 to work) 
; for 1.0.23 up cnfg parms accumulate until NDI IO command
; 18-22 required you set drive first.

Select
	set8	0x18,0,bt.drv	;drive number
	db	0xff

; load  this to do IO

DIO
	set16	0x10,0,bt.dma	;system tranfer address
	set16	0x22,0,bt.trk	;track number
	set16	0x24,0,bt.sec	;sector number
	set8	0x00,0,bt.cmd	;NDI command
	db	0xff

; load this to read ID sector 

LIO
	set16	010h,log.buf	;DMA address of Log buffer
	set16	022h,0		;Track 0
	set16	024h,1		;Sector 1
	set8	0x00,cmd.read	;NDI command
	db	0xff

;---------

; CfgData is for variable config Data set after reading ID sector
CfgData
	set8	0a1h,2,bt.hds		;Heads

	set8	0a3h,2,bt.Ddat		;density	(data) 	Double
	set16	0a4h,50,bt.SPTdat	;SPT		(data) 

	set8	0c3h,2,bt.Dsys		;density	(SYS) 	Double
	set16	0c4h,50,bt.SPTsys	;SPT		(SYS) 

	set8	0,127			;issue null command to set all parameters.

	db	0xFF

; Log Data is set before read ID sector and configures Non-variable config parameters.
;writing to disk conf interface does not set parameters until a disk IO command is issued
; for 1.0.18-1.0.22 Drive MUST be selected first or failure occurs. 
; For 1.0.23 up parameters accumulate and are set by IO (no need to select first)
; the parameters are set by disk IO command in LIO

LogData	
	set8	080h,0			;order
	set8	081h,1			;formatType
;	set8 	082h,0			;DONT use prepost

	set16	09ah,0			;IDM flag	0

	set16	0a0h,77			;Cylinders
;	set8	0a1h,2,bt.hds		;Heads		

;	set8	0a3h,2,bt.Ddat		;density	(data) 	Double
;	set16	0a4h,50,bt.SPTdat	;SPT		(data) 
	set8	0a5h,0			;Sector Size	(data) 	128
	set8	0a6h,2			;clock		(data) 	8inch

	set16	0b2h,1			;#t0
	set8	0b3h,1			;density	(T0) 	Single
	set16	0b4h,26			;SPT		(T0) 
	set8	0b5h,0			;Sector Size	(T0) 	128
	set8	0b6h,2			;clock		(T0)	8inch

	set16	0c2h,1			;#sys
;	set8	0c3h,2,Dsys		;density	(SYS) 	Double
;	set16	0c4h,50,SPTsys		;SPT		(SYS) 
	set8	0c5h,0			;Sector Size	(SYS) 	128
	set8	0c6h,2			;clock		(SYS) 	8inch

	db	0ffh			;end it

; this routine feeds data to the New Disk Interface
; the data is in a parameter block as
; size(1) port(1) data (1 or 2) terminated with 0xFF
; entry -  hl points to parameter block

FeedNDI
another	mov	a,m	;got size 1=low 2=low/high and FF=finished
	cpi	0ffh
	jz	finished
	cpi	2
	jz	do2
do1	inx	hl
	mov	a,m	;got register selector in a
	out	ndi.Sel	;out to select port
	inx	hl
	mov	a,m	;got value to out to register
	out 	ndi.LO	; out to low reg
	inx	hl
	jmp 	another
do2	inx	hl
	mov	a,m	;got register selector in a
	out	ndi.Sel	;out to select port
	inx	hl
	mov	a,m	;got value to out to low register
	out 	ndi.Lo	; out to low reg
	inx	hl
	mov	a,m	;got value to out to high register
	out 	ndi.Hi	; out to high reg
	inx	hl
	jmp 	another
finished
	ret	

; disk status

dsk.sts
	mvi	a,8	;select for status register
	out 	ndi.Sel
	in	ndi.Lo
	ana	a	;set status
	ret

;disk login

dsk.log
	lxi	hl,Select	;select is done first only to support 1.0.18-1.0.22
	call	feedNDI

	lxi	hl,LogData	;set defaults needed to read ID sector
	call	FeedNDI

	lxi	hl,LIO		; finalize set of parms and read ID sector
	call	FeedNDI

	call	dsk.sts		; we did a read so get status
	
	ret

;Disk Configure after Log in (Select Drive NDI parameter is already set)

dsk.cfg

;these parameter values are found in the DPB

	call	dpb.ad		;de points to dpb
	xchg			;hl ->dpb SPT data
	lxi	b,dpb.sz
	dad	b		;hl -> to CPM3 physicals
	xra	a
	mov	m,a		;set CPM3 PHS and PHM to 0
	inx 	hl
	mov	m,a


	call	dpb.ad		;de points to dpb
	xchg			;hl ->dpb SPT data
	mov	a,m
	sta	bt.SPTdat
	inx	h
	mov	a,m
	sta	bt.SPTdat+1

	lxi	hl,CfgData
	call	feedNDI
	
	ret

;disk executive

dsk.ex
	lxi	h,Select	;select is done first only to support 1.0.18-1.0.22
	call 	FeedNDI

	lxi	h,DIO
	call	FeedNDI	

	call	dsk.sts
	
	ret

;block move (z80 LDIR register usage)

block	mov	a,m		;
	stax	d		;
	inx	h		;
	inx	d		;
	dcx	b		;
	mov	a,b		;
	ora	c		;
	jnz	block		;
	ret			;

;log on set dpb

log.on	lda	log.rq		;check log on req
	ani	&H01		;log on bit test
	jnz	dsk.ok		;already logged on

;read id sector

	call	dsk.log

	jz	log.ck		;id sector got read
	lxi	h,0		;bad log on hl=0(no Drive table)
	jmp	dsk.er		;exit error

;check if a JADE disk

log.ck	
	lxi	h,log.buf	;get address of dd
	lxi	d,jadeid	;de points to id value
	mvi	b,id.sze	;label size
log.id	ldax	d		;get label character
	cmp	m		;match?
	jnz	lg3740		;assume IBM3740
;	inx	h		;point to next chars
;	inx	d		;
	dcr	b		;dec count of characters
	jnz	log.id		;again

;diskette contains JADE id

	call	trnone		;no sector translation

	call	dpb.ad		;get dpb address in de
	lxi	h,log.buf+log.dpb	;get address of dpb in log.buf

	lxi	b,dpb.sz	;size of dpb
	call	block		;move dpb on dd to bios dpb


; by happenstance, 48 spt z80 emulator disks UNUSED field (log.ddf-1) contain 6 and 50 spt contain 0

;get value of log.ddf-1
	lda	log.buf+log.ddf-1	;a is either 6 or 0
	ani	2		;a now is either 2 or 0
	cma			;a now is partially negated(need add 1)
	adi	51		;a now is either 48 or 50 (plus 51)
	sta	bt.SPTsys	;store in config block

;	assume SYS tracks are double density

	mvi	a,2		; density is double=2
	sta	bt.Dsys		; store in config block

	lda	log.buf+log.ddf		;get density flags from sector(id) buffer
	mov	b,a		;save for later
	rar
	rar
	rar
	ani	1		;0 for single sided 1 for double sided
	inr	a		;now 1 for single sided 2 for double sided
	sta	bt.hds

	mov	a,b

	ani	&H04		;test data trk-2 density
	cz	tr3740		;if single density use 3740

	rar
	rar
	ani	1		;0 for single 1 for double
	INR	A		;now 1 for single 2 for double
	sta	bt.Ddat

	call	dsk.cfg

	lhld	dt.ptr		;reload ptr to dph table
	jmp	dsk.ok		;return with drv ptr in hl

;assume 3740

lg3740	call	tr3740		;translate for 3740

	mvi	a,26		; a=26 for IBM 3740
	sta	bt.SPTsys	;store in config block

	mvi	a,1		; density is single=1
	sta	bt.Dsys		; store in config block
	sta	bt.Ddat		; store in config block
	sta	bt.hds		; store in config block

	call	dpb.ad		;get dpb address in de
	lxi	b,dpb.sz	;size of dpb
	lxi	h,sd.pbk	;hl points to single density dpb 3740
	call	block		;move single dens dpb  to bios dpb

	call	dsk.cfg

	lhld	dt.ptr		;reload ptr to dph table
	jmp	dsk.ok		;return with drv ptr in hl


;set 3740 sector translation

tr3740	lxi	d,sdtran	;single density translation table
	lhld	dt.ptr		;ptr to dph table
	mov	m,e		;put xlat table pointer into dph at 0
	inx	h		;
	mov	m,d		;
	ret

;set no xlation

trnone	xra	a		;zero
	lhld	dt.ptr		;ptr to dph table
	mov	m,a		;put null xlat table pointer into dph at 0
	inx	h		;
	mov	m,a		;
	ret

;get drv par block address

dpb.ad	lhld	dt.ptr		;ptr to dph table
	lxi	d,10		;
	dad	d		;d points to dpb in dph
	mov	e,m		;get dpb from dph at offset 10
	inx	h		;
	mov	d,m		;
	ret


seldsk	lxi	h,0		;hl = zero if error
	mov	a,c		;put drive number in a
	sta	bt.drv		;store drive number
	cmpi	n.drvs		;check if legal drive number
	rnc			;ret if illegal
	mov	a,e		;chk if need log on
	sta	log.rq		;save log on req in log.rq
retdsk	lda	bt.drv		;get drv number
	mov	l,a		;l=drive number
	mvi	h,0		;clear h
	dad	h		;*2
	dad	h		;*4
	dad	h		;*8
	dad	h		;*16
	lxi	d,d0.dph	;first dph
	dad	d		;hl=dph of drv number in c
	shld	dt.ptr	;store drive table pointer
	jmp	log.on

;home drive

home	mvi	c,0		;set track to 0
	
;set track

settrk	mov	a,c		;track no in a from c
	sta	bt.trk		;store track number
	ret

;set sector

setsec	mov	a,c		;sector no in a from c
	sta	bt.sec		;store sector number
	ret

;set dma

setdma	mov	h,b		;just save in bt.dma
	mov	l,c		;
	shld	bt.dma		;
	ret

;sector translation

sectrn	mov	a,d		;testing tbl addr
	ora	e		;chk if 0
	jz	notran		;no xlation
	xchg			;hl=xlat tbl
	dad	b		;hl + sec offset
	mov	l,m		;
	mvi	h,0		;assumed 8 bit sector numbers
	ret	
notran	lxi	h,1		;add one to sector number and ret
	dad	b		
	ret	

;define console io ports

cni.sp	equ	&H7d
cni.sb	equ	&H02
cni.si	equ	&H00
cni.dp	equ	&H7c

cno.sp	equ	&H7d
cno.sb	equ	&H01
cno.si	equ	&H00
cno.dp	equ	&H7c

io.rdy	equ	&HFF	;ready
asc.msk	equ	&H7F	;ascii mask

lf	equ	&H0a
cr	equ	&H0d
cntl.z	equ	&H1A

;console input status


cns.ck	in	cni.sp		;in status
	xri	cni.si		;adjust polarity
	ani	cni.sb		;mask status bit
	rz			;return zero if not ready
	mvi	a,io.rdy	;set ready
	ret			;return

;console input

cns.in	call	cns.ck		;check status
	jz	cns.in		;repeat untill ready
	in	cni.dp		;in character
	ani	asc.msk		;mask to 7 bit ascii
	ret			;return

;console output

cns.ot	in	cno.sp		;in status
	xri	cno.si		;adjust polarity
	ani	cno.sb		;mask status bit
	jz	cns.ot		;repeat untill ready
	mov	a,c		;get character in a
	ani	asc.msk		;mask to 7 bit ascii
	out	cno.dp		;out character
	ret			;return

;reader and punch

reader	mvi	a,cntl.z	;return eof
	ret			;return

punch	ret			;throw away

;printer

;list	jmp	cns.ot		;send to console
	
;listst	mvi	a,io.rdy	;ready
;	ret			;return

;printer

lst$dp	equ	7eH		;list data port
lst$st	equ	7fH		;list status port
lst$ctl	equ	lst$st		;control port
lst$msk	equ	00000001B	;status mask (ORPLY)
ctl$msk	equ	00000001b	;control mask (OSTB)
mem$msk	equ	00000010b	;sbc mem mask 10=out 00=in

listst	in	lst$st		;
	ani	lst$msk		;
	rz			;not ready
	mvi	a,0ffh		;ready
	ret
	
list	call	listst		;get status
	jz	list		;wait for ready
	mov	a,c		;get char from c
	out	lst$dp		;out char to data port
	mvi	a,ctl$msk	;strobe data
	out	lst$ctl		;strobe
	ret			;return

;display string

msg.ot	push	psw		;save ccr and a
..rept	mov	c,m		;get char fron where hl points
	call	cns.ot		;output char
	mov	a,m		;get char again to test sign
	inx	hl		;inc to next char
	ani	&H80		;test sign bit
	jz	..rept		;repeat until sign bit set
	pop	psw		;restore ccr and a
	ret			;;return

;warm boot loads ccp + bdos sets up page zero

warm	lxi	sp,&H0080	;set up stack in def buffer
;	mvi	a,0		;drive 0
;	sta	bt.drv		;select disk
	mvi	c,0		;drive zero
	mvi	e,0		; do login
	call	seldsk		; select disk and configure
	lxi	b,ccp		;cpm ccp address
	call	setdma		;set dma
	mvi	c,2		;first ccp sector
	call	setsec		;set sector
	mvi	c,1		;ccp/bdos track
	call	settrk		;set track
	
;read ccp and bdos

w.read	call	diskrd		;read one sector
	ana	a		;set flags(ccr)
	jnz	w.eror		;exit if error
	lda	bt.sec		;get sector number
	cmpi	45		;last track???
	jz	w.zrpg		;go init page zero
	inr	a		;next sector
	sta	bt.sec		;store next sector
	lxi	d,sec.sz	;sector size
	lhld	bt.dma		;inc buffer pointer to next sec
	dad	d		;new buffer address 
	shld	bt.dma		;store new buffer address
	jmp	w.read		;again

w.eror	lxi	h,msg.le	;display error msg
	call	msg.ot		;and
	hlt			;halt

;init page zero

w.zrpg	mvi	a,0c3h		;jmp xxxx = (c3 xx xx)
	sta	0		;
	lxi	h,bios+03	;jmp bios+3(warm)
	shld	1
	sta	5		;jmp instruction
	lxi	h,bdos+06	;jmp bdos (ccp+6)
	shld	6
;	sta	38h		;rst 7
;	lxi	h,0e003h	;jmp sdmon(e003)
;	shld	39h

;last logged drive

	lda	c.disk		;last drive used
	mov	c,a		;ccp expects it in c

	lxi	h,&H0080	;set default dma
	shld	bt.dma		;

;jump to ccp

;	mvi	c,0		;default disk=0
	jmp	ccp		;go to cpm

;disk request parameters

d.addr	equ	&h0040		;address of dd

;3740 parameters

sdtran	db	&H01,&H07,&H0d,&H13,&H19,&H05
	db	&H0b,&H11,&H17,&H03,&H09,&H0f
	db	&H15,&H02,&H08,&H0e,&H14,&H1a
	db	&H06,&H0c,&H12,&H18,&H04,&H0a
	db	&H10,&H16

;default drive parametr block

sd.pbk	dw	26		;spt
	db	3		;bsh
	db	7		;blm
	db	0		;null mask
	dw	242		;exm
	dw	63		;dsm
	db	&hc0		;drm
	db	0		;al0/al1
	dw	16		;cks
	dw	2		;off

;messages

msg.le	db	cr,lf
	text	"LOAD ERRO"
	db	&H52+&H80

;id label

jadeid	text	"Jade ID " ;"JADE ID" ?????
id.sze	equ	$-jadeid

;drive parameter area

d0.dph	dw	0		;xlat table
	dw	0		;scratch area
	dw	0		;scratch area
	dw	0		;scratch area
	dw	dir.bf		;directory buffer
	dw	d0.dpb		;drive parameter block
	dw	d0.chk		;chk for disk change area
	dw	d0.all		;drive allocation table
d1.dph	dw	0
	dw	0
	dw	0
	dw	0
	dw	dir.bf
	dw	d1.dpb
	dw	d1.chk
	dw	d1.all
d2.dph	dw	0
	dw	0
	dw	0
	dw	0
	dw	dir.bf
	dw	d2.dpb
	dw	d2.chk
	dw	d2.all
d3.dph	dw	0
	dw	0
	dw	0
	dw	0
	dw	dir.bf
	dw	d3.dpb
	dw	d3.chk
	dw	d3.all

; bios.sz (eob - bios) MUST be <= 0x400 for xbios to work
; bios.sz (eob - bios) MUST be <= 0x600 for bootldr to work
eob:	equ	$
bios.sz equ	eob-bios

	if 	bios.sz gt 0x400
	error	"Bios is too Big"
	endif

;Un-initialized data area

	org	ui$data

;reserve drive parameter block DPB's

dpb.sz	equ	15	;size of drive parameter block


d0.dpb	ds	dpb.sz	;reserve 15 byte for drive 0
	ds	2	; for CPM3 compatibility 

d1.dpb	ds	dpb.sz	;reserve 15 byte for drive 1
	ds	2

d2.dpb	ds	dpb.sz	;reserve 15 byte for drive 2
	ds	2

d3.dpb	ds	dpb.sz	;reserve 15 byte for drive 3
	ds	2

; drive allocation area

all.sz equ	33

d0.all	equ	$
d1.all	equ	d0.all+all.sz
d2.all	equ	d1.all+all.sz
d3.all	equ	d2.all+all.sz

;changed disk area

chk.sz	equ	32

d0.chk	equ	d3.all+all.sz
d1.chk	equ	d0.chk+chk.sz
d2.chk	equ	d1.chk+chk.sz
d3.chk	equ	d2.chk+chk.sz

log.buf equ	d3.chk+chk.sz

eoui	equ	log.buf+080h