; This format/initialize program is for the Z80 emulator implementation
;  of the Jade DD Single/Double Sided, Single/Double Density, 48/50 SPT
;  Disk Images (it does NOT support Emulator's JADEDD Formats with 48SPT on track 0)
;Supported are 
; JadeSSSD    26/48/26 SPT 77 tracks
; JadeSSDD    26/48/48 SPT 77 tracks
; Jade50SSSD  26/50/26 SPT 77 tracks
; Jade50SSDD  26/50/50 SPT 77 tracks
; Jade50DSSD  26/50/26 SPT 154 tracks
; Jade50DSDD  26/50/50 SPT 154 tracks
;
;This program detects the type of disk by reading the Emulators Disk Confgiuration data
; IT initializes according to what type of disk image is defined.
; IF the image open does not match, it will be treated as that format anyway
; Possibly doing NOT what you wanted. LOGIN the drive if you want to use the 
; BIOS to set the Config parameters using the existing  Jade ID table on the disk image. 
;
; Driver Module Definitions

LF	EQU	0AH
CR	EQU	0DH
TPA	EQU	0100H
CNTL.C	EQU	3
TRK.0	EQU	0
TRK.1	EQU	1
TRK.2	EQU	2
TRK.76	EQU	76
TRK.153	EQU	153
SEC.SZ	EQU	128
ID.SEC	EQU	1
REBOOT	EQU	0

;SYSTEM TRACK COPY DEFINITIONS

TK0.LP	EQU	02000H
TK0.FS	EQU	1
TK0.LS	EQU	26
TK0.NS	EQU	TK0.LS-TK0.FS+1
TK0.LC	EQU	TK0.LP-SEC.SZ*TK0.FS
TK0.SZ	EQU	SEC.SZ*TK0.NS
TK1.LP	EQU	TK0.LP+TK0.SZ
TK1.FS	EQU	1
TK1.LS	EQU	48	;copy 48 even on 50 SPT


;INJECTION MODULE DEFINITIONS

FMT.EA	EQU	1700H
WD.TRK	EQU	05H
WD.DTA	EQU	07H
XP.DSH	EQU	080H
ZEROS	EQU	0
ONES	EQU	0FFH

; BDOS CALL VECTORS

BDOS	EQU	05H
CNS.RD	EQU	1
CNS.WR	EQU	2

;BIOS VECTOR DEFINITIONS

BS.DSK	EQU	01BH
BS.TRK	EQU	01EH
BS.SEC	EQU	021H
BS.DMA	EQU	024H
BS.RDS	EQU	027H
BS.WRS	EQU	02AH
BS.FMT	EQU	033H
BS.PAG	EQU	02H

	I8080
	ORG	TPA

;PROGRAM BEGINS

BEGIN:	JMP	INIT

	DB	"JADE COMPUTER PRODUCTS"
	DB	"DOUBLE D 48/50 SPT - FORMAT"
	DB	"VERSION 2.2-Z80 EMULATOR"

INIT:
; check for proper emulator version

	in 	0xc4		;read major number
	cpi 	1		;port c4 not implemented in wrong vers
	jc	Ver.Bad		; less than 1 = bad
	cpi	0xff		;returns either 0 or ff if bad
	jz	Ver.Bad
	in	0xc6		;read minor number
	cpi	23
	jnc	Ver.OK
Ver.Bad	lxi	h,msg.die	;death message
	call	msg.ot		;out message
	ret			;exit if bad so disks dont get trashed
msg.die	db	cr,lf,lf
	text	"Requires Z80 Emulator Version 1.0.23 or higher"
	db	cr,lf+0x80
Ver.OK

	LXI	SP,TPA
	LXI	H,MSG.BG
	CALL	MSG.OT

FUN.BG:	LXI 	H,MSG.FL
	CALL	MSG.OT
	CALL	CNS.IN
	CPI	'0'
	JZ	FUN.LOGIN
	CPI	'1'
	JZ	FUN.InitID
	CPI	'2'
	JZ	FUN.InitDISK
	CPI	'3'
	JZ	FUN.InitSYS
	CPI	'4'
	JZ	FUN.InitDATA
	CPI	'5'
	JZ	FUN.RS
	CPI	'6'
	JZ	FUN.WS
	CPI	'I'
	JZ	FUN.IBM
	CPI	'i'
	JZ	FUN.IBM
	CPI	'&'
	JZ	RST.6
	CPI	'/'
	JZ	RST.7
	sta	ltr.se
	LXI	H,MSG.SE
	CALL	MSG.OT
	JMP	FUN.BG

FUN.LOGIN
	LXI	H,MSG.LD
	CALL	SEL.DR.LOG
	Jmp	FUN.BG

FUN.InitID
	LXI	H,MSG.ID
	CALL	SEL.DR.NOLOG
	JC	FUN.BG
	call	CalcVector
	
	lxi	h,JT.InitID
	rla	
	mov	e,a
	xra	a
	mov	d,a
	dad	d
	mov	e,m
	inx	h
	mov	d,m
	xchg
	pchl
	
JT.InitID
	dw	WrongType
	dw	WrongType
	dw	FUN.ID48.SS
	dw	FUN.ID48.SD
	dw	FUN.ID50.SS
	dw	FUN.ID50.SD
	dw	FUN.ID50.DS
	dw	FUN.ID50.DD
	
WrongType
	LXI	H,MSG.WT
	CALL	MSG.OT
	jmp	FUN.BG

FUN.InitDISK
	LXI	H,MSG.FD
	CALL	SEL.DR.NOLOG
	JC	FUN.BG
	call	CalcVector
	
	lxi	h,JT.InitDISK
	rla	
	mov	e,a
	xra	a
	mov	d,a
	dad	d
	mov	e,m
	inx	h
	mov	d,m
	xchg
	pchl
	
JT.InitDISK
	dw	WrongType
	dw	WrongType
	dw	FUN.FT48.SS
	dw	FUN.FT48.SD
	dw	FUN.FT50.SS
	dw	FUN.FT50.SD
	dw	FUN.FT50.DS
	dw	FUN.FT50.DD
	

FUN.InitSYS
	LXI	H,MSG.FST
	CALL	SEL.DR.NOLOG
	JC	FUN.BG
	call	CalcVector
	
	lxi	h,JT.InitSYS
	rla	
	mov	e,a
	xra	a
	mov	d,a
	dad	d
	mov	e,m
	inx	h
	mov	d,m
	xchg
	pchl
	
JT.InitSYS
	dw	WrongType
	dw	WrongType
	dw	FUN.ST48.SS
	dw	FUN.ST48.SD
	dw	FUN.ST50.SS
	dw	FUN.ST50.SD
	dw	FUN.ST50.DS
	dw	FUN.ST50.DD

FUN.InitDATA
	LXI	H,MSG.FDT
	CALL	SEL.DR.NOLOG
	JC	FUN.BG
	call	CalcVector
	
	lxi	h,JT.InitDATA
	rla	
	mov	e,a
	xra	a
	mov	d,a
	dad	d
	mov	e,m
	inx	h
	mov	d,m
	xchg
	pchl
	
JT.InitDATA
	dw	WrongType
	dw	WrongType
	dw	FUN.DT48.SS
	dw	FUN.DT48.SD
	dw	FUN.DT50.SS
	dw	FUN.DT50.SD
	dw	FUN.DT50.DS
	dw	FUN.DT50.DD



;FUNCTION  WRITE ID 48 SPT SINGLE Sided SINGLE Density

FUN.ID48.SS
	LDA	F48.SS
	STA	F.FLAG
	LXI	H,ID48.SS
	CALL	WRT.ID
	JMP	FUN.InitID	

;FUNCTION  WRITE ID 48 SPT SINGLE Sided DOUBLE Density

FUN.ID48.SD
	LDA	F48.SD
	STA	F.FLAG
	LXI	H,ID48.SD
	CALL	WRT.ID
	JMP	FUN.InitID	

;FUNCTION  WRITE ID 50 SPT SINGLE Sided SINGLE Density

FUN.ID50.SS
	LDA	F50.SS
	STA	F.FLAG
	LXI	H,ID50.SS
	CALL	WRT.ID
	JMP	FUN.InitID	

;FUNCTION  WRITE ID 50 SPT SINGLE Sided DOUBLE Density

FUN.ID50.SD
	LDA	F50.SD
	STA	F.FLAG
	LXI	H,ID50.SD
	CALL	WRT.ID
	JMP	FUN.InitID	

;FUNCTION  WRITE ID 50 SPT DOUBLE Sided SINGLE Density

FUN.ID50.DS
	LDA	F50.DS
	STA	F.FLAG
	LXI	H,ID50.DS
	CALL	WRT.ID
	JMP	FUN.InitID	;ID50.DS

;FUNCTION  WRITE ID 50 SPT DOUBLE Sided DOUBLE Density

FUN.ID50.DD
	LDA	F50.DD
	STA	F.FLAG
	LXI	H,ID50.DD
	CALL	WRT.ID
	JMP	FUN.InitID	

;FUNCTION  FORMAT 48 SINGLE sided DOUBLE Density

FUN.FT48.SD
	LDA	F48.SD
	STA	F.FLAG
	MVI	A,TRK.0
	STA	TRK.NO
	CALL	FMT.26
	JC	FUN.InitDISK
	MVI	A,TRK.1
	STA	TRK.NO
..REPT	CALL	FMT.48
	JC	FUN.InitDISK
	LDA	TRK.NO
	CPI	TRK.76
	JZ	WRID48.SD
	INR	A
	STA	TRK.NO
	JMP	..REPT
WRID48.SD
	LXI	H,ID48.SD
	CALL	WRT.ID
	JMP	FUN.InitDISK

;FUNCTION  FORMAT 48 Single sided SINGLE Density

FUN.FT48.SS
	LDA	F48.SS
	STA	F.FLAG
	MVI	A,TRK.0
	STA	TRK.NO
	CALL	FMT.26
	JC	FUN.InitDISK
	MVI	A,TRK.1
	STA	TRK.NO
	CALL	FMT.48
	JC	FUN.InitDISK
	MVI	A,TRK.2
	STA	TRK.NO
..REPT	CALL	FMT.26
	JC	FUN.InitDISK
	LDA	TRK.NO
	CPI	TRK.76
	JZ	WRID48.SS
	INR	A
	STA	TRK.NO
	JMP	..REPT
WRID48.SS
	LXI	H,ID48.SS
	CALL	WRT.ID
	JMP	FUN.InitDISK

;FUNCTION  FORMAT 50 SINGLE sided DOUBLE Density

FUN.FT50.SD
	LDA	F50.SD
	STA	F.FLAG
	MVI	A,TRK.0
	STA	TRK.NO
	CALL	FMT.26
	JC	FUN.InitDISK
	MVI	A,TRK.1
	STA	TRK.NO
..REPT	CALL	FMT.50
	JC	FUN.InitDISK
	LDA	TRK.NO
	CPI	TRK.76
	JZ	WRID50.SD
	INR	A
	STA	TRK.NO
	JMP	..REPT
WRID50.SD
	LXI	H,ID50.SD
	CALL	WRT.ID
	JMP	FUN.InitDISK

;FUNCTION  FORMAT 50 Single sided SINGLE Density

FUN.FT50.SS
	LDA	F50.SS
	STA	F.FLAG
	MVI	A,TRK.0
	STA	TRK.NO
	CALL	FMT.26
	JC	FUN.InitDISK
	MVI	A,TRK.1
	STA	TRK.NO
	CALL	FMT.50
	JC	FUN.InitDISK
	MVI	A,TRK.2
	STA	TRK.NO
..REPT	CALL	FMT.26
	JC	FUN.InitDISK
	LDA	TRK.NO
	CPI	TRK.76
	JZ	WRID50.SS
	INR	A
	STA	TRK.NO
	JMP	..REPT
WRID50.SS
	LXI	H,ID50.SS
	CALL	WRT.ID
	JMP	FUN.InitDISK

;FUNCTION  FORMAT 50 DOUBLE sided DOUBLE Density

FUN.FT50.DD
	LDA	F50.DD
	STA	F.FLAG
	MVI	A,TRK.0
	STA	TRK.NO
	CALL	FMT.26
	JC	FUN.InitDISK
	MVI	A,TRK.1
	STA	TRK.NO
..REPT	CALL	FMT.50
	JC	FUN.InitDISK
	LDA	TRK.NO
	CPI	TRK.153
	JZ	WRID50.DD
	INR	A
	STA	TRK.NO
	JMP	..REPT
WRID50.DD
	LXI	H,ID50.DD
	CALL	WRT.ID
	JMP	FUN.InitDISK

;FUNCTION  FORMAT 50 DOUBLE sided SINGLE Density

FUN.FT50.DS
	LDA	F50.DS
	STA	F.FLAG
	MVI	A,TRK.0
	STA	TRK.NO
	CALL	FMT.26
	JC	FUN.InitDISK
	MVI	A,TRK.1
	STA	TRK.NO
	CALL	FMT.50
	JC	FUN.InitDISK
	MVI	A,TRK.2
	STA	TRK.NO
..REPT	CALL	FMT.26
	JC	FUN.InitDISK
	LDA	TRK.NO
	CPI	TRK.153
	JZ	WRID50.DS
	INR	A
	STA	TRK.NO
	JMP	..REPT
WRID50.DS
	LXI	H,ID50.DS
	CALL	WRT.ID
	JMP	FUN.InitDISK


;FUNCTION  FORMAT STANDARD 3740

FUN.IBM	MVI	A,0
	STA	F.FLAG
	LXI	H,MSG.FD
	CALL	SEL.DR.NOLOG
	JC	FUN.BG
	MVI	A,TRK.0
	STA	TRK.NO
..REPT	CALL	FMT.26
	JC	FUN.IBM
	LDA	TRK.NO
	CPI	TRK.76
	JZ	FUN.IBM
	INR	A
	STA	TRK.NO
	JMP	..REPT

;FUNCTION  FORMAT JADE SYSTEM TRACKS ONLY 48 SINGLE Sided SINGLE Density

FUN.ST48.SS	
	LDA	F48.SS
	STA	F.FLAG
	MVI	A,TRK.0
	STA	TRK.NO
	CALL	FMT.26
	JC	FUN.InitSYS
	MVI	A,TRK.1
	STA	TRK.NO
	CALL	FMT.48
	JC	FUN.InitSYS
	LXI	H,ID48.SS
	CALL	WRT.ID
	JMP	FUN.InitSYS

;FUNCTION  FORMAT JADE SYSTEM TRACKS ONLY 48 SINGLE Sided DOUBLE Density

FUN.ST48.SD
	LDA	F48.SD
	STA	F.FLAG
	MVI	A,TRK.0
	STA	TRK.NO
	CALL	FMT.26
	JC	FUN.InitSYS
	MVI	A,TRK.1
	STA	TRK.NO
	CALL	FMT.48
	JC	FUN.InitSYS
	LXI	H,ID48.SD
	CALL	WRT.ID
	JMP	FUN.InitSYS

;FUNCTION  FORMAT JADE SYSTEM TRACKS ONLY 50 SINGLE Sided SINGLE Density

FUN.ST50.SS	
	LDA	F50.SS
	STA	F.FLAG
	MVI	A,TRK.0
	STA	TRK.NO
	CALL	FMT.26
	JC	FUN.InitSYS
	MVI	A,TRK.1
	STA	TRK.NO
	CALL	FMT.50
	JC	FUN.InitSYS
	LXI	H,ID50.SS
	CALL	WRT.ID
	JMP	FUN.InitSYS

;FUNCTION  FORMAT JADE SYSTEM TRACKS ONLY 50 SINGLE Sided DOUBLE Density

FUN.ST50.SD
	LDA	F50.SD
	STA	F.FLAG
	MVI	A,TRK.0
	STA	TRK.NO
	CALL	FMT.26
	JC	FUN.InitSYS
	MVI	A,TRK.1
	STA	TRK.NO
	CALL	FMT.50
	JC	FUN.InitSYS
	LXI	H,ID50.SD
	CALL	WRT.ID
	JMP	FUN.InitSYS

;FUNCTION  FORMAT JADE SYSTEM TRACKS ONLY 50 DOUBLE Sided SINGLE Density

FUN.ST50.DS	
	LDA	F50.DS
	STA	F.FLAG
	MVI	A,TRK.0
	STA	TRK.NO
	CALL	FMT.26
	JC	FUN.InitSYS
	MVI	A,TRK.1
	STA	TRK.NO
	CALL	FMT.50
	JC	FUN.InitSYS
	LXI	H,ID50.DS
	CALL	WRT.ID
	JMP	FUN.InitSYS

;FUNCTION  FORMAT JADE SYSTEM TRACKS ONLY 50 DOUBLE Sided DOUBLE Density

FUN.ST50.DD
	LDA	F50.DD
	STA	F.FLAG
	MVI	A,TRK.0
	STA	TRK.NO
	CALL	FMT.26
	JC	FUN.InitSYS
	MVI	A,TRK.1
	STA	TRK.NO
	CALL	FMT.50
	JC	FUN.InitSYS
	LXI	H,ID50.DD
	CALL	WRT.ID
	JMP	FUN.InitSYS

;FUNCTION  FORMAT DATA TRACKS ONLY 48 SINGLE sided DOUBLE Density

FUN.DT48.SD
	LDA	F48.SD
	STA	F.FLAG
	MVI	A,TRK.2
	STA	TRK.NO
..REPT	CALL	FMT.48
	JC	FUN.InitDATA
	LDA	TRK.NO
	CPI	TRK.76
	JZ	FUN.InitDATA
	INR	A
	STA	TRK.NO
	JMP	..REPT

;FUNCTION  FORMAT DATA TRACKS ONLY 48 SINGLE sided SINGLE Density

FUN.DT48.SS
	LDA	F48.SS
	STA	F.FLAG
	MVI	A,TRK.2
	STA	TRK.NO
..REPT	CALL	FMT.26
	JC	FUN.InitDATA
	LDA	TRK.NO
	CPI	TRK.76
	JZ	FUN.InitDATA
	INR	A
	STA	TRK.NO
	JMP	..REPT

;FUNCTION  FORMAT DATA TRACKS ONLY 50 SINGLE sided DOUBLE Density

FUN.DT50.SD
	LDA	F50.SD
	STA	F.FLAG
	MVI	A,TRK.2
	STA	TRK.NO
..REPT	CALL	FMT.50
	JC	FUN.InitDATA
	LDA	TRK.NO
	CPI	TRK.76
	JZ	FUN.InitDATA
	INR	A
	STA	TRK.NO
	JMP	..REPT

;FUNCTION  FORMAT DATA TRACKS ONLY 50 SINGLE sided SINGLE Density

FUN.DT50.SS
	LDA	F50.SS
	STA	F.FLAG
	MVI	A,TRK.2
	STA	TRK.NO
..REPT	CALL	FMT.26
	JC	FUN.InitDATA
	LDA	TRK.NO
	CPI	TRK.76
	JZ	FUN.InitDATA
	INR	A
	STA	TRK.NO
	JMP	..REPT

;FUNCTION  FORMAT DATA TRACKS ONLY 50 DOUBLE sided DOUBLE Density

FUN.DT50.DD
	LDA	F50.DD
	STA	F.FLAG
	MVI	A,TRK.2
	STA	TRK.NO
..REPT	CALL	FMT.50
	JC	FUN.InitDATA
	LDA	TRK.NO
	CPI	TRK.153
	JZ	FUN.InitDATA
	INR	A
	STA	TRK.NO
	JMP	..REPT

;FUNCTION  FORMAT DATA TRACKS ONLY 50 DOUBLE sided SINGLE Density

FUN.DT50.DS
	LDA	F50.DS
	STA	F.FLAG
	MVI	A,TRK.2
	STA	TRK.NO
..REPT	CALL	FMT.26
	JC	FUN.InitDATA
	LDA	TRK.NO
	CPI	TRK.153
	JZ	FUN.InitDATA
	INR	A
	STA	TRK.NO
	JMP	..REPT

;FUNCTION  READ SYSTEM TRACKS

FUN.RS
	LXI	H,MSG.RS
	CALL	SEL.DR.LOG
	JC	FUN.BG
	MVI	A,BS.RDS
	STA	RW.OPV
	CALL	TRNSFR
	JMP	FUN.BG

;FUNCTION  WRITE SYSTEM TRACKS

FUN.WS
	LXI	H,MSG.WS
	CALL	SEL.DR.LOG
	JC	FUN.BG
	MVI	A,BS.WRS
	STA	RW.OPV
	CALL	TRNSFR
	JMP	FUN.WS

;MESSAGE DISPLAY

MSG.OT
	PUSH	PSW
..REPT
	MOV	A,M
	CALL	CNS.OT
	MOV	A,M
	INX	H
	ANI	080H
	JZ	..REPT
	POP	PSW
	RET

; CONSOLE LINKAGE - BDOS CALLS

CNS.IN
	MVI	C,CNS.RD
	CALL	BDOS
	ANI	07FH
	CPI	CNTL.C
	JZ	REBOOT
	RET
	
CNS.OT	PUSH	H
	MOV	E,A
	MVI	C,CNS.WR
	CALL	BDOS
	POP	H
	RET

; DISPLAY HEX VALUE

HXW.OT	MOV	A,H
	CALL	HXB.OT
	MOV	A,L
HXB.OT	PUSH	PSW
	RRC
	RRC
	RRC
	RRC
	CALL	HXN.OT
	POP	PSW
HXN.OT	ANI	00FH
	CPI	00AH
	JC	HX.NM
	ADI	'A'-'9'-1
HX.NM	ADI	'0'
	JMP	CNS.OT

;WRITE ID SECTOR
; enter with HL->ID info sector data

; SET DMA
WRT.ID	MOV	B,H
	MOV	C,L
	MVI	L,BS.DMA
	CALL	BIOS
; SET TRACK TO ZERO
	MVI	C,TRK.0
	MVI	L,BS.TRK
	CALL	BIOS
; SET SECTOR TO id SECTOR
	MVI	C,ID.SEC
	MVI	L,BS.SEC
	CALL	BIOS
;DO WRITE
	MVI	L,BS.WRS
	CALL	BIOS
	ORA	A
	JNZ	WRT.ERR

	LDA	DR.SEL
	MOV	C,A
	MVI	E,0	;LOG VECTOR SAYS TO LOG DRIVE
	MVI	L,BS.DSK
	CALL	BIOS
	mov	A,h
	add	l
	JZ 	WRT.ERR
	ret

;	LXI	H,DUM.BUF	;not needed for dd50bios
;	MOV	B,H
;	MOV	C,L
;	MVI	L,BS.DMA
;	CALL	BIOS
;	MVI	L,BS.RDS	; DO AN OPERATION TO SET spt
;	CALL	BIOS		; JUST TO MAKE z80 EMU DRIVE PROPERTIES LOOK GOOD
;	
;	RZ
WRT.ERR
	LXI	H,MSG.NC
	CALL	MSG.OT
	RET

;FORMAT TRACK

;NOTE--THESE ARE REPLACED WITH ROUTINES TO SIMPLY WRITE E5 TO EACH SECTOR OF THE TRACK
;SINCE THE BIOS FORMAT FOR Z80 EMULATOR DOES NOTHING AND RETURNS GOOD
;  

FMT.50
	MVI	A,50
	JMP	FMT.FMT
FMT.48
	MVI	A,48
	JMP	FMT.FMT
FMT.26
	MVI	A,26
	JMP	FMT.FMT

; entry
; 	A=number of sectors to format
; 	Trk.No=track
; 	Sec.Dta=data to write
; uses
; 	Sec.No 

FMT.FMT
	STA	SEC.NO

	LXI	H,SEC.DTA
	MOV	B,H
	MOV	C,L
	MVI	L,BS.DMA
	CALL	BIOS

	LDA	TRK.NO
	MOV	C,A	
	MVI	L,BS.TRK
	CALL	BIOS

FMT.NXS
	LDA	SEC.NO
	ANA	A
	RZ

	MOV	C,A	

	DCR 	A		;DEC SECTOR
	STA	SEC.NO		;NEXT SECTOR

	MVI	L,BS.SEC
	CALL	BIOS
	
	MVI	L,BS.WRS
	CALL	BIOS

	ORA	A
	JZ	FMT.NXS

	LXI	H,MSG.NC
	CALL	MSG.OT
	stc
	RET

; TRANFER SYSTEM TRACKS

; TRANSFER TRACK 0
;  TRACK 0 IS MOVED WITH SECTOR STAGGER
;  AND PLACED IN MEMORY STAGGERED 
;  SO THAT IN THE END , ITS IN ORDER
; APPARENTLY FOR SPEED ON REAL DD

; entry
;	RW.OPV=read or write

TRNSFR
	LXI	H,TK0.SL
	INX	H		;SKIP ID SECTOR
	SHLD	SYS.WP
	MVI	C,TRK.0
	MVI	L,BS.TRK
	CALL	BIOS
;SET SECTOR IN BIOS
..TK0S
	LHLD	SYS.WP
	MOV	C,M
	MVI	L,BS.SEC
	CALL	BIOS
;SET ADDRESS IN BIOS
	LHLD	SYS.WP
	ANA	A
	MOV	A,M
	RAR
	MOV	D,A
	MVI	A,0
	RAR
	MOV	E,A
	LXI	H,TK0.LC
	DAD	D
	MOV	B,H
	MOV	C,L
	MVI	L,BS.DMA
	CALL	BIOS
;SECTOR TRANSFER
	LDA	RW.OPV
	MOV	L,A
	CALL	BIOS
	ORA	A
	JNZ	TF.EX
;INCREMENT NEXT SECTOR
	LHLD	SYS.WP
	MOV	A,M
	CPI	016H
	JZ	TR.TRK1
	INX	H
	SHLD	SYS.WP
	JMP	..TK0S

; TRANSFER TRACK 1

TR.TRK1	LXI	H,TK1.LP
	SHLD	SYS.WP
	MVI	A,TRK.1
	STA	SEC.NO
	MVI	C,TRK.1
	MVI	L,BS.TRK
	CALL	BIOS
;SET SECTOR AND DMA IN BIOS
..TK1S	LDA	SEC.NO
	MOV	C,A
	MVI	L,BS.SEC
	CALL	BIOS
	LHLD	SYS.WP
	MOV	B,H
	MOV	C,L
	MVI	L,BS.DMA
	CALL 	BIOS
;SECTOR TRANFER
	LDA	RW.OPV
	MOV	L,A
	CALL	BIOS
	ORA	A
	JNZ	TF.EX
;INC NEXT SECTOR
	LDA	SEC.NO
	CPI	TK1.LS
	RZ
	INR	A
	STA	SEC.NO
	LHLD	SYS.WP
	LXI	D,SEC.SZ
	DAD	D
	SHLD	SYS.WP
	JMP	..TK1S
;BAD STUFF 
TF.EX	LXI	H,MSG.NC
	CALL	MSG.OT
	RET

;SELECT DRIVE THRU BIOS

SEL.DR.LOG
	mvi	a,0
	jmp	Select
SEL.DR.NOLOG
	mvi	a,1
Select
	sta	log.vc
	SHLD	MSG.SV
..REPT	LHLD	MSG.SV
	CALL	MSG.OT
	CALL	CNS.IN
	CPI	CR
	JZ	SEL.EX
;SEE IF DRIVE LETTER IS GOOD
	STA	DR.LTR
	STA	DR.LTR.log
	STA	LTR.SE
	STA	LTR.LE
	SUI	'A'
	JC	SEL.IL
	CPI	04H
	JC	SEL.NB
	SUI	'a'-'A'
	JC	SEL.IL
	CPI	04H
	JC	SEL.NB
; EXIT TO RESELECT
SEL.IL
	LXI	H,MSG.SE
	CALL	MSG.OT
	JMP	..REPT
; EXIT TO RESELECT
SEL.EX
	STC
	RET
;VALID DRIVE
SEL.NB
	STA	DR.SEL
	lda	log.vc
	ora	a
	jnz	xx
	LXI	H,MSG.XY
	jmp	xxx
xx	LXI	H,MSG.XX
xxx	CALL	MSG.OT
	CALL	CNS.IN
	CPI	CR
	JNZ	..REPT
	lda	dr.sel
	MOV	C,A
	lda	log.vc	;LOG.VC 1=noLOGON 0=LOGON
	Mov	E,a	
	MVI	L,BS.DSK
	CALL	BIOS
	mov	a,h
	add	l
	jnz	OK.sel
	LXI	H,MSG.LE
	CALL	MSG.OT
	JMP	..REPT
OK.sel
	call	GetDiskParams	
	ANA	A
	RET

;	STA	DR.SEL
;	MOV	C,A
;	lda	log.vc	;LOG.VC 1=noLOGON 0=LOGON
;	Mov	E,a	
;	MVI	L,BS.DSK
;	CALL	BIOS
;	LXI	H,MSG.XX
;	CALL	MSG.OT
;	CALL	CNS.IN
;	CPI	CR
;	JNZ	..REPT
;	call	GetDiskParams	
;	ANA	A
;	RET
;
; LOGIN DRIVE
;
;LOG.DR	SHLD	MSG.SV
;..REPT	LHLD	MSG.SV
;	CALL	MSG.OT
;	CALL	CNS.IN
;	CPI	CR
;	JZ	SEL.EX
;SEE IF DRIVE LETTER IS GOOD
;	STA	DR.LTR.log
;	STA	LTR.SE
;	STA	LTR.LE
;	SUI	'A'
;	JC	LOG.IL
;	CPI	04H
;	JC	LOG.NB
;	SUI	'a'-'A'
;	JC	LOG.IL
;	CPI	04H
;	JC	LOG.NB
; EXIT TO RESELECT
;LOG.IL
;	LXI	H,MSG.SE
;	CALL	MSG.OT
;	JMP	..REPT
; EXIT TO RESELECT
;LOG.EX	STC
;	RET
;VALID DRIVE
;LOG.NB
;	STA	DR.SEL
;	LXI	H,MSG.XY
;	CALL	MSG.OT
;	CALL	CNS.IN
;	CPI	CR
;	JNZ	..REPT
;	lda	dr.sel
;	MOV	C,A
;	MVI	E,0	; DO LOGon
;	MVI	L,BS.DSK
;	CALL	BIOS
;	mov	a,h
;	add	l
;	jnz	OK.LOG
;	LXI	H,MSG.LE
;	CALL	MSG.OT
;	JMP	..REPT
;OK.LOG
;	ANA	A
;	RET

;Get disk Parameters from NDI

GetDiskParams
	mvi	a,0x18	;Drive
	out	0xca
	lda	DR.SEL
	out	0xc8

	mvi	a,0	;execute NULL command to set parameters so we can read. 
	out 	0xca
	mvi	a,127	;  127 does not test. 
	out	0xc8

	mvi	a,0x81	;Homo/hetero
	out	0xca
	in	0xc8
	sta	HH

	mvi	a,0xa1	;Heads
	out	0xca
	in	0xc8
	sta	Heads

	mvi	a,0xa4	;SPT Data
	out	0xca
	in	0xc8
	sta	SPT.DATA

	mvi	a,0xb4	;SPT T0
	out	0xca
	in	0xc8
	sta	SPT.T0

	mvi	a,0xc4	;SPT SYS
	out	0xca
	in	0xc8
	sta	SPT.SYS
	ret
;Determine the jmp vector to use

Tmp.Add	dw	0
Tmp.Cnt db	0

Specs	db	0,1,26,26,26,1	;IBM
	db	1,1,26,26,26,1	;IBM
	db	1,1,26,48,26,2	;48sssd
	db	1,1,26,48,48,3	;48ssdd
	db	1,1,26,50,26,4	;50sssd
	db	1,1,26,50,50,5	;50ssdd
	db	1,2,26,50,26,6	;50dssd
	db	1,2,26,50,50,7	;50dsdd
	
; compares disk params to specs and returns 1-7 if good and 0 if bad

CalcVector
	mvi	a,8
	sta	Tmp.Cnt
	lxi	h,Specs
next	shld	Tmp.Add

	lxi	d,HH
	mvi	b,5
again	mov	c,m	;hl->specs
	xchg
	mov	a,m	;de->HH,Heads,T0,sys,data
	xchg
	cmp	c
	jnz	no.cmp
	inx	h
	inx	d
	dcr	b
	jnz	again
did.cmp	mov	a,m
	ret
no.cmp	lxi	d,6
	lhld	Tmp.Add
	dad	d
	lda	tmp.Cnt
	dcr	a
	jz	not.find
	sta	tmp.cnt
	jmp	next
not.find
	xra	a
	ret

;BIOS TRANSFER ROUTINE

BIOS	LDA	BS.PAG
	MOV	H,A
	PCHL

;SOFTWARE TRAPS

RST.6	RST	6
RST.7	RST	7

	db	" HERE IT IS "
;WORKING VARIABLES

SYS.WP	DW	0
RW.OPV	DB	0
MSG.SV	DW	0
TRK.NO	DB	0
SEC.NO	DB	0
F.FLAG	DB	0
DR.SEL 	DB	0
LOG.VC	DB	1

;FORMAT TRACK Variables

HH		db	0
HEADS		DB	0
SPT.T0		Db	0
SPT.SYS		Db	0
SPT.DATA	Db	0


;3740 TRANSLATION

TK0.SL	DB	01H,07H,0DH,13H,19H,05H
	DB	0BH,11H,17H,03H,09H,0FH
	DB	15H,02H,08H,0EH,14H,1AH
	DB	06H,0CH,12H,18H,04H,0AH
	DB	10H,16H

;******************************************************
;JADE SINGLE DENSITY ID SECTOR
;******************************************************

ID48.SS	db	"JADE DD SINGLE DENSITY FORMAT "
	org	ID48.SS+020h
	dw	26
	db	3
	db	07h
	db	0
	dw	242
	dw	63
	db	0C0h
	db	0
	dw	16
	dw	2
	org	ID48.SS+030h
	db	6
F48.SS	db	00000010B
	ORG	ID48.SS+SEC.SZ

;******************************************************
;JADE DOUBLE DENSITY ID SECTOR
;******************************************************

ID48.SD	db	"JADE DD DOUBLE DENSITY FORMAT "
	org	ID48.SD+020h
	dw	48
	db	4
	db	0fh
	db	1
	dw	224
	dw	63
	db	080h
	db	0
	dw	16
	dw	2
	org	ID48.SD+030h
	db	6
F48.SD	db	00000110B
	ORG	ID48.SD+SEC.SZ

;******************************************************
; JADE SINGLE DENSITY - IDENTITY SECTORS	      *
;******************************************************

ID50.SS	db	"Jade DD S Sided S Density Format "

	org	ID50.SS+20H	;LOCATE CP/M 2.2 DPB.
	dw	26		;SECTORS PER TRACK.
	db	3		;BLOCK SHIFT FACTOR.
	db	7		;BLOCK MASK.
	db	0		;EXM.
	dw	26*75/8-1	;DISK SIZE - 1.
	dw	63		;DIRECTORY MAXIMUM.
	db	11000000B	;ALLOC 0.
	db	0		;ALLOC 1.
	dw	16		;CHECK SIZE.
	dw	2		;TRACK OFFSET.

	org	ID50.SS+30H	;LOCATE DCM BLOCK.
	db	0		;NOT USED.
F50.SS	db	00000010B	;DISKETTE FLAGS.

	org	ID50.SS+SEC.SZ	;EXTEND FULL SECTOR.

;******************************************************

ID50.DS	db	"Jade DD D Sided S Density Format "

	org	ID50.DS+20H	;LOCATE CP/M 2.2 DPB.
	dw	26		;SECTORS PER TRACK.
	db	4		;BLOCK SHIFT FACTOR.
	db	15		;BLOCK MASK.
	db	1		;EXM.
	dw	26*152/16-1	;DISK SIZE - 1.
	dw	63		;DIRECTORY MAXIMUM.
	db	10000000B	;ALLOC 0.
	db	0		;ALLOC 1.
	dw	16		;CHECK SIZE.
	dw	2		;TRACK OFFSET.

	org	ID50.DS+30H	;LOCATE DCM BLOCK.
	db	0		;NOT USED.
F50.DS	db	00001010B	;DISKETTE FLAGS.

	org	ID50.DS+SEC.SZ	;EXTEND FULL SECTOR.

;******************************************************
; JADE DOUBLE DENSITY - IDENTITY SECTORS	      *
;******************************************************

ID50.SD:	db	"Jade DD S Sided D Density Format "

	org	ID50.SD+20H	;LOCATE CP/M 2.2 DPB.
	dw	50		;SECTORS PER TRACK.
	db	4		;BLOCK SHIFT FACTOR.
	db	00001111B	;BLOCK MASK.
	db	1		;EXM.
	dw	50*75/16-1	;DISK SIZE - 1.
	dw	63		;DIRECTORY MAXIMUM.
	db	10000000B	;ALLOC 0.
	db	0		;ALLOC 1.
	dw	16		;CHECK SIZE.
	dw	2		;TRACK OFFSET.

	org	ID50.SD+30H	;LOCATE DCM BLOCK.
	db	0		;NOT USED.
F50.SD	db	00000110B	;DISKETTE FLAGS.

	org	ID50.SD+SEC.SZ	;EXTEND TO FULL SIZE

;******************************************************

ID50.DD:	db	"Jade DD D Sided D Density Format "

	org	ID50.DD+20H	;LOCATE CP/M 2.2 DPB.
	dw	50		;SECTORS PER TRACK.
	db	5		;BLOCK SHIFT FACTOR.
	db	31		;BLOCK MASK.
	db	3		;EXM.
	dw	50*152/32-1	;DISK SIZE - 1.
	dw	127		;DIRECTORY MAXIMUM.
	db	10000000B	;ALLOC 0.
	db	0		;ALLOC 1.
	dw	32		;CHECK SIZE.
	dw	2		;TRACK OFFSET.

	org	ID50.DD+30H	;LOCATE DCM BLOCK.
	db	0		;NOT USED.
F50.DD
	db	00001110B	;DISKETTE FLAGS.

	org	ID50.DD+SEC.SZ	;EXTEND TO FULL SIZE


;MESSAGES

;CONSOLE SIGN IN
MSG.BG
	DB	CR,LF
	DB	CR,LF,"DOUBLE D - 8 inch INITILIZE UTILITY"
	DB	CR,LF,"SINGLE/DOUBLE SIDED 48/50 SPT for Z80 EMULATOR"
	DB	CR,LF,"MUST SELECT TYPE of DISK IMAGE FIRST"
	DB	CR,LF,"  Jade50SSSD, Jade50SSDD, Jade50DSSD, Jade50DSDD"
	db	cr,lf,"  JadeSSSD, JadeSSDD OR IBM3740"
	DB	CR,LF
	DB	CR,LF,"USE CTL-C FOR SYSTEM REBOOT",'.'+80H
;DISPLAY FUNCTION SELECTION
MSG.FL
	DB	CR,LF
	DB	CR,LF,"******* FUNCTIONS LIST *********"
	DB	CR,LF
	DB	CR,LF,"0. LOGIN DRIVE"
	DB	CR,LF,"1. WRITE ID SECTOR"
	DB	CR,LF,"2. INITILIZE"
	DB	CR,LF,"3. INITILIZE SYSTEM TRACKS ONLY"
	DB	CR,LF,"4. INITILIZE DATA TRACKS ONLY"
	DB	CR,LF,"5. READ   System Tracks Image"
	DB	CR,LF,"6. WRITE  System Tracks Image"
	DB	CR,LF,"I. INITILIZE STANDARD IBM3740 8 INCH"
	DB	CR,LF
	DB	CR,LF,"ENTER FUNCTION NUMBER:",' '+080H
;SELECTION ERROR
MSG.SE
	DB	CR,LF
	DB	CR,LF
LTR.SE	DB	' '
	DB	" IS NOT A VALID SELECTION",' '+80H
;LOGIN ERROR
MSG.LE
	DB	CR,LF
	DB	CR,LF
LTR.LE	DB	' '
	DB	" Could NOT be LOGGED IN",' '+80H
; WRITE ID ON DISK DRIVE
MSG.ID
	DB	CR,LF
	DB	CR,LF
	DB	"WRITE ID ON DRIVE (CR TO RESELECT):",' '+80H
; FORMAT ON DISK DRIVE
MSG.FD
	DB	CR,LF
	DB	CR,LF
	DB	"FORMAT  DRIVE (CR TO RESELECT):",' '+80H
; LOG ON DISK DRIVE
MSG.LD
	DB	CR,LF
	DB	CR,LF
	DB	"LOGIN DRIVE (CR TO RESELECT):",' '+80H
;Wrong type of disk
MSG.WT
	DB	CR,LF
	DB	CR,LF
	DB	"Not a Jade Format",' '+80H
; FORMAT ON DISK DRIVE
MSG.FST
	DB	CR,LF
	DB	CR,LF
	DB	"FORMAT SYSTEM TRACKS ON DRIVE (CR TO RESELECT):",' '+80H
; FORMAT ON DISK DRIVE
MSG.FDT
	DB	CR,LF
	DB	CR,LF
	DB	"FORMAT DATA TRACKS ON DRIVE (CR TO RESELECT):",' '+80H
; READ SYSTEM ON DISK DRIVE
MSG.RS
	DB	CR,LF
	DB	CR,LF
	DB	"READ SYSTEM FROM DRIVE:",' '+80H
; WRITE SYSTEM ON DISK DRIVE
MSG.WS
	DB	CR,LF
	DB	CR,LF
	DB	"WRITE SYSTEM TO DRIVE (CR TO RESELECT):",' '+80H
; TRANSFER INCOMPLETE
MSG.NC
	DB	CR,LF
	DB	CR,LF
	DB	"TRANSFER INCOMPLETE",' '+80H
; TYPE CR WHEN READY
MSG.XX
	DB	CR,LF
	DB	CR,LF,"Open Disk Image and Select Image Format then TYPE CR When DRIVE "
DR.LTR	DB	' '
	DB	" READY",'.'+80H
; TYPE CR WHEN READY
MSG.XY
	DB	CR,LF
	DB	CR,LF,"Open Disk Image then TYPE CR When DRIVE "
DR.LTR.log	DB	' '
	DB	" READY to be Logged In",'.'+80H

;SECTOR FORMAT DATA

SEC.DTA	
	REPT	8
	DB	0XE5,0XE5,0XE5,0XE5,0XE5,0XE5,0XE5,0XE5,0XE5,0XE5,0XE5,0XE5,0XE5,0XE5,0XE5,0XE5
	ENDM

;DUM.BUF	DS 	128
EOFMT
	if EOFMT gt TK0.LP
	error "Format is too big Must be less than 0x1000"
	endif
	END