		ORG	$0
iSP		DC.l	$b00
iPC		DC.l	rENTRY
		dc.l	$0

		org	$f00000+$c		
JMPTBL:
		bra.w	jTrace
		bra.w	jBOCMD
		bra.w	jABORTB
		bra.w	jCHKBP
		bra.w	jCHECKSUM
		bra.w	jDISKR
		bra.w	jDISKW
		bra.w	jINITVECT
		bra.w	jINITHRAM
		bra.w	jINCHS
		bra.w	jOUTCHS
		bra.w	jPOINTRAM
		bra.w	jNA3C
		bra.w	jHOTSTART
		bra.w	jNA44
		bra.w	jNA48

vVectors:
vSP		DC.l	$b00
vPC		DC.l	rReset
vBERR		DC.l	rBerr
vAERR		DC.l	rAerr
vILL		DC.l	rILL
vDIv		DC.l	rDIv
vCHK		DC.l	rCHK
vTRAPv	DC.l	rTrapv
vPRIv		DC.l	rPriv
vTRACE	DC.l	rTrace
vLINEA	DC.l	rLineA
vLINEF	DC.l	rLineF
v12		DC.l	rUnass
v13		DC.l	rUnass
vFORMAT	DC.l	rFormat
vUNINT	DC.l	rUnInt
v16		DC.l	rUnass
v17		DC.l	rUnass
v18		DC.l	rUnass
v19		DC.l	rUnass
v20		DC.l	rUnass
v21		DC.l	rUnass
v22		DC.l	rUnass
v23		DC.l	rUnass
vSPURINT	DC.l	rSpurInt
vAv1		DC.l	rAv1
vAv2		DC.l	rAv2
vAv3		DC.l	rAv3
vAv4		DC.l	rAv4
vAv5		DC.l	rAv5
vAv6		DC.l	rAv6
vAv7		DC.l	rAv7
vTRAP0	DC.l	rTrap0
vTRAP1	DC.l	rTrap1
vTRAP2	DC.l	rTrap2
vTRAP3	DC.l	rTrap3
vTRAP4	DC.l	rTrap4
vTRAP5	DC.l	rTrap5
vTRAP6	DC.l	rTrap6
vTRAP7	DC.l	rTrap7
vTRAP8	DC.l	rTrap8
vTRAP9	DC.l	rTrap9
vTRAP10	DC.l	rTrap10
vTRAP11	DC.l	rTrap11
vTRAP12	DC.l	rTrap12
vTRAP13	DC.l	rTrap13
vTRAP14	DC.l	rTrap14
vTRAP15	DC.l	rTrap15
v48		DC.l	rUnass
v49		DC.l	rUnass
v50		DC.l	rUnass
v51		DC.l	rUnass
v52		DC.l	rUnass
v53		DC.l	rUnass
v54		DC.l	rUnass
v55		DC.l	rUnass
v56		DC.l	rUnass
v57		DC.l	rUnass
v58		DC.l	rUnass
v59		DC.l	rUnass
v60		DC.l	rUnass
v61		DC.l	rUnass
v62		DC.l	rUnass
v63		DC.l	rUnass

scmCR0	EQU	$F19F05
scmCR1	EQU	$F19F07
scmCR2	EQU	$F19F09
scmCR3	EQU	$F19F0B
scmCR4	EQU	$F19F0D
scmCR5	EQU	$F19F0F
scmCR6	EQU	$F19F11
scmGOFF	equ	$f19f13
scmSR		EQU	$F19F85

scmCR1US	EQU	$01
scmCR1IG	EQU	$80

crtcADD	equ	$f1a021
crtcREG	equ	$f1a023

		ORG		$400
* this is area in ram where trap15 stores variables..
BootLine	ds.b	$100
*CnfgArea		ds.l	12	* 44 bytes plus 2 reserved plus 2 extra	
CnfgArea	ds.b	$100
SaveReg	ds.l	16
SaveSSP	ds.l	1
SaveUSP	ds.l	1
StkSR		ds.w	1
StkPC		ds.l	1
StkVO		ds.w	1
SupFlg	ds.b	2
NPBytes	ds.w	1
Funct		ds.w	1
VectOff	ds.w	1
CPUTYPE	ds.l	1	* store CPU type here 0 , 10 , 32
STACKS	ds.l	1	* store supported stack frames here xxxC xxx8 xxxx x2x0

M400C0BA	ds.l	1	* 0 if no card, else Base Address of 400 card 0
M400C1BA	ds.l	1	* 0 if no card, else Base Address of 400 card 1
M410C0BA	ds.l	1	* 0 if no card, else Base Address of 410 card 0

BOOTIPC	ds.b	1	* IPC of Boot drive
BOOTDISK	ds.b	1	* LUN of Boot Drive

DSKBLK:	
DSKCLUN	ds.b	1	* Controller Lun
DSKDLUN	ds.b	1	* device Lun
DSKSTSW	ds.w	1	* status word
DSKMEM	ds.l	1	* DMA Memory
DSKLSN	ds.l	1	* LSN 
DSKNBLKS	ds.w	1	* numberr of blocks to read
DSKAM		ds.w	1	* address modifier

PTRRAM	equ	*	
StRAM		ds.l	1	* $b00
EndRAM	ds.l	1	* $5FFFF
PTRDCT	ds.l	1	* DCT
DRVCTRL	ds.l	1	* IPCNUM

MEMBEG	ds.l	1
MEMEND	ds.l	1

IPCNUM	ds.b	1
DRVNUM	ds.b	1
LSNNUM	ds.l	1
NUMLSN	ds.w	1
DMAADD	ds.l	1


rENTRY	
* move PROGRAM IN ROM(AT EOP) TO RAM(AT $F00000+EOP)
		LEA		EOP,A0
		LEA		$F00000+EOP,A1
		moveq.l	#$10,d0	* only need to do $8 for emu, since no prefetch
MLTU		move.l	(A0)+,(A1)+
		DBRA		D0,MLTU
		JMP		INROM
EOP
		org		EOP+$F00000

INROM		ori.B		#scmCR1US,scmCR1


* move VECTORS IN ROM(AT $F00000) TO RAM(AT 0)	
rReset
		LEA		vVectors,A0
		LEA		0,A1

		move.w	#63,D0		*64 remaining
MUTL0
		move.l	(A0)+,(A1)+
		DBF		D0,MUTL0

		move.l	#rSpurInt,d1	*set all interrupts to spurious
		move.w	#191,D0		*192 remaining
MUTL1
		move.l	d1,(A1)+
		DBF		D0,MUTL1

* clear ram from 400-aff
		move.w	#$1bf,D0		
MUTL2
		clr.l		(A1)+
		DBF		D0,MUTL2

* these are special emulator only MOVEC operations...		
		DC.L 		$4E7A0704 	* MOVEC CPUTYPE,D0
		move.l	d0,CPUTYPE
		DC.L 		$4E7A0705 	* MOVEC STACKS,D0
		move.l	d0,STACKS

* Init IOC Cards MVME400 and MVME410
		jsr		Init400C0
		jsr		Init400C1
		jsr		Init410C0

* Do Sign on message
		jsr		DoSom

* this is special emulator only MOVEC operation...		
		DC.L 		$4E7A0707 	* MOVEC BootDisk,D0
* was needed because normally Tenbug supplies disk for disk IO
		move.b	d0,BOOTDISK
		move.b	d0,DRVNUM
		move.b	#0,BOOTIPC
		move.b	#0,IPCNUM

		move.l	#$400,MEMBEG
		move.l	#$5FFFF,MEMEND
		move.l	#MEMBEG,StRAM
		move.l	#MEMEND,EndRAM

		move.l	#CnfgArea,PTRDCT
		move.l	#IPCNUM,DRVCTRL

* set up display
		move.b	#$80,scmCR6

		bsr.w		IHMLR25	* init to High Res MemMap, Low Res Graphics, 80x25

* Do ROM DONE on message
		jsr		DoRomD

		BRA		*

ROMDONE	dc.b		'BSOD ROM DONE',13,10,0
SOMSG		dc.b		'BSOD ROM Version 181022',13,10
		dc.b		' Trap 15 Support and TENbug Jump Table',0
SOMCPUt	dc.b		' CPU Type is ',0
SOMStks	dc.b		' Stack Formats supported are ',0
Ct000		dc.b		'MC68000',0
Ct010		dc.b 		'MC68010',0
Ct32h		dc.b		'CPU32hyb',0
Ct32		dc.b		'CPU32',0

Fnone		dc.b		'68000',0
F08		dc.b		'0,8',0
F028		dc.b		'0,2,8',0
F02C		dc.b		'0,2,C',0
		even

BMBa		move.b	(a0)+,(a1)+
BMovB:	dbf		d0,BMBa
		rts
BMWa		move.w	(a0)+,(a1)+
BMovW:	dbf		d0,BMWa
		rts
BMLa		move.l	(a0)+,(a1)+
BMovL:	dbf		d0,BMLa
		rts
* do ROM done
DoRomD:
		MOVE.W 	#$12,$A04 	* "M" LATCH IS ZERO BITS 128 OFF  *
 		MOVE.W 	#$32,$A04 	* "M" LATCH IS ONE  CHAR "D" ON   *
		MOVE.W 	#$2F,$A04 	* "L" LATCH IS ZERO BITS ALL OFF  *
		MOVE.W 	#$3F,$A04 	* "L" LATCH IS ONE  CHAR "0" ON   

		bsr.w		NEWLINE
		lea		ROMDONE,a0
		jsr		PRINTS

		bsr.w		NEWLINE
		rts

* do sign on
DoSom:
		MOVE.W 	#$12,$A04 	* "M" LATCH IS ZERO BITS 128 OFF  *
 		MOVE.W 	#$32,$A04 	* "M" LATCH IS ONE  CHAR "D" ON   *
		MOVE.W	#$24,$A04 	* "L" LATCH IS ZERO BITS ALL OFF  *
		MOVE.W 	#$34,$A04 	* "L" LATCH IS ONE  CHAR "B" ON   

		bsr.w		NEWLINE
		lea		SOMSG,a0
		jsr		PRINTS

		bsr.w		NEWLINE
		lea		SOMCPUt,a0
		jsr		PRINTS

		cmp.l		#0,CPUTYPE
		bne.b		CSO0
		lea		Ct000,a0
		jsr		PRINTS
		bra.b		CSO2
CSO0
		cmp.l		#10,CPUTYPE
		bne.b		CSO1
		lea		Ct010,a0
		jsr		PRINTS
		bra.b		CSO2
CSO1
		cmp.l		#32,CPUTYPE
		bne.b		CSO2
		lea		Ct32h,a0
		jsr		PRINTS
CSO2
		bsr.w		NEWLINE
		lea		SOMStks,a0
		jsr		PRINTS

		cmp.l		#0,STACKS
		bne.b		CSO3
		lea		Fnone,a0
		jsr		PRINTS
		bra.b		CSO5
CSO3
		cmp.l		#$0101,STACKS
		bne.b		CSO4
		lea		F08,a0
		jsr		PRINTS
		bra.b		CSO5
CSO4
		cmp.l		#$0105,STACKS
		bne.b		CSO5
		lea		F028,a0
		jsr		PRINTS
CSO5
		bsr.w		NEWLINE
		rts

M400B0	equ		$f1c1c1

M4PDA		equ		$00	* PIA A Data/DDR 
M4PCA		equ		$02 	* PIA A CA		
M4PDB		equ		$04	* PIA B Data/DDR 
M4PCB		equ		$06	* PIA B CA
M4NDA		equ		$08 	* 7201 Data A	
M4NDB		equ		$0a	* 7201 Data B	
M4NCA		equ		$0c	* 7201 Control A	
M4NCB		equ		$0e	* 7201 Control B	

Init400C0:
		movem.l	d0/a0,-(a7)
		move.w	sr,-(a7)
* test for device present
		lea		M400B0,a0
		bsr	 	DevPr
		move.l	a0,M400C0BA
		beq.w		NoM400C0
* set up PIA Side-A
		move.b 	#$00,M4PCA(a0)	* pia Ca
		move.b 	#$18,M4PDA(a0)	* pia DDRa
		move.b 	#$04,M4PCA(a0)	* pia Ca
		move.b	#$00,M4PDA(a0)	* turn off LED
* set up PIA Side-B
		move.b 	#$00,M4PCB(a0)	* pia Cb
		move.b 	#$ff,M4PDB(a0)	* pia DDRb
		move.b 	#$04,M4PCB(a0)	* pia Cb
		move.b	#$ee,M4PDA(a0)	* baud A/B at 9600/9600
* set up M400C0 Port A and B
		move.b	#$02,M4NCA(a0)
		move.b	#$14,M4NCA(a0)	* CR2A
		move.b	#$02,M4NCB(a0)
		move.b	#$00,M4NCB(a0)	* CR2B
* set up M400C0 Port A
		move.b	#$04,M4NCA(a0)
		move.b	#$44,M4NCA(a0)	* CR4
		move.b	#$03,M4NCA(a0)
		move.b	#$e1,M4NCA(a0)	* CR3
		move.b	#$05,M4NCA(a0)
		move.b	#$ea,M4NCA(a0)	* CR5

		move.b	#$01,M4NCA(a0)
		move.b	#$00,M4NCA(a0)	* CR1
* set up M400C0 Port B
		move.b	#$04,M4NCB(a0)
		move.b	#$44,M4NCB(a0)	* CR4
		move.b	#$03,M4NCB(a0)
		move.b	#$e1,M4NCB(a0)	* CR3
		move.b	#$05,M4NCB(a0)
		move.b	#$ea,M4NCB(a0)	* CR5

		move.b	#$01,M4NCB(a0)
		move.b	#$04,M4NCB(a0)	* CR1 affects vector must just be for fun
NoM400C0:
		move.w 	(a7)+,sr
		movem.l 	(a7)+,d0/a0
		rts

M400B1	equ		$f1c1a1

Init400C1:
		movem.l	d0/a0,-(a7)
		move.w	sr,-(a7)
* test for device present
		lea		M400B1,a0
		bsr	 	DevPr
		move.l	a0,M400C1BA
		beq.w		NoM400C1
* set up PIA Side-A
		move.b 	#$00,M4PCA(a0)	* pia Ca
		move.b 	#$18,M4PDA(a0)	* pia DDRa
		move.b 	#$04,M4PCA(a0)	* pia Ca
		move.b	#$00,M4PDA(a0)	* turn off LED
* set up PIA Side-B
		move.b 	#$00,M4PCB(a0)	* pia Cb
		move.b 	#$ff,M4PDB(a0)	* pia DDRb
		move.b 	#$04,M4PCB(a0)	* pia Cb
		move.b	#$ee,M4PDA(a0)	* baud A/B at 9600/9600
* set up M400C1 Port A and B
		move.b	#$02,M4NCA(a0)
		move.b	#$14,M4NCA(a0)	* CR2A
		move.b	#$02,M4NCB(a0)
		move.b	#$00,M4NCB(a0)	* CR2B
* set up M400C1 Port A
		move.b	#$04,M4NCA(a0)
		move.b	#$44,M4NCA(a0)	* CR4
		move.b	#$03,M4NCA(a0)
		move.b	#$e1,M4NCA(a0)	* CR3
		move.b	#$05,M4NCA(a0)
		move.b	#$ea,M4NCA(a0)	* CR5

		move.b	#$01,M4NCA(a0)
		move.b	#$00,M4NCA(a0)	* CR1
* set up M400C1 Port B
		move.b	#$04,M4NCB(a0)
		move.b	#$44,M4NCB(a0)	* CR4
		move.b	#$03,M4NCB(a0)
		move.b	#$e1,M4NCB(a0)	* CR3
		move.b	#$05,M4NCB(a0)
		move.b	#$ea,M4NCB(a0)	* CR5

		move.b	#$01,M4NCB(a0)
		move.b	#$04,M4NCB(a0)	* CR1 
NoM400C1:
		move.w 	(a7)+,sr
		movem.l 	(a7)+,d0/a0
		rts

PBASE1	equ		$f1c1e1
PBASE2	equ		$f1c1e9
PDATA  	equ		$0
PDATB		equ		$4
PCNTRLA	equ		$2
PCNTRLB	equ		$6
PSTATA	equ		PCNTRLA
PSTATB	equ		PCNTRLB
PDDRA		equ		PDATA
PDDRB		equ		PDATB

PACKN		equ		PSTATA
PSTRB		equ		PCNTRLA
PRDY		equ		PDATB

Init410C0:
		movem.l	d0/a0,-(a7)
		move.w	sr,-(a7)
* test for device present
		lea		PBASE1,a0
		bsr	 	DevPr
		move.l	a0,M410C0BA
		beq.w		NoM410C0
* set up first PIA port 

		MOVE.B	#$38,PCNTRLA(a0)
		MOVE.B	#$ff,PDDRA(a0)

		MOVE.B	#$3c,PCNTRLA(a0)

		MOVE.B	#$38,PCNTRLB(a0)
		MOVE.B	#$80,PDDRB(a0)

		MOVE.B	#$3c,PCNTRLB(a0)
		MOVE.B	#0,PDDRB(a0)	*turn off LED
* set up second PIA port 
		lea		PBASE2,a0

		MOVE.B	#$38,PCNTRLA(a0)
		MOVE.B	#$ff,PDDRA(a0)

		MOVE.B	#$3c,PCNTRLA(a0)

		MOVE.B	#$38,PCNTRLB(a0)
		MOVE.B	#$00,PDDRB(a0)

		MOVE.B	#$3c,PCNTRLB(a0)
NoM410C0:
		move.w 	(a7)+,sr
		movem.l 	(a7)+,d0/a0
		rts

* Print a Character on LPT
PCHAR:
		movem.l	d2/a0,-(a7)
		move.w	sr,-(a7)

		tst.l		M410C0BA	* Dont output if no 410 card
		beq.w		PRSTR

		lea		PBASE1,a0

		move.b	PRDY(a0),d2
		and.b		#3,d2
		move.b	d2,d1
		sub.b		#1,d1
		bne.b		PRSTR

PSEND		move.b	d0,PDATA(a0)
		move.b	PDATA(a0),d2	* clear ack

PSTROBE	move.b	#$34,PSTRB(a0)
		move.b	#$3c,PSTRB(a0)

PACKNGE	btst.b	#7,PACKN(a0)
		beq.b		PACKNGE

PRSTR		move.w 	(a7)+,sr
		movem.l 	(a7)+,d2/a0
		rts
				
******  Initialize character and graphics display
IHMHR50:	bset.b	#4,scmCR1
		move.b	#$32,scmGOFF
		lea		H80x50,a0
		bra.b		IDisp

IHMHR25:	bset.b	#4,scmCR1
		move.b	#$32,scmGOFF
		lea		H80x25,a0
		bra.b		IDisp

IHMLR25:	bset.b	#4,scmCR1
		clr.b		scmGOFF
		lea		L80x25,a0
		bra.b		IDisp

ILMLR25:	bclr.b	#4,scmCR1
		clr.b		scmGOFF
		lea		L80x25,a0

IDisp: 
		move.w	#12,d0
L1:		move.b 	(a0)+,crtcADD
		move.b	(a0)+,crtcREG
		dbra		d0,L1
		rts

L80x25:	dc.w		$0062
		dc.w		$0150
		dc.w		$0256
		dc.w		$0311
		dc.w		$0419
		dc.w		$0503
		dc.w		$0619
		dc.w		$0719
		dc.w		$0800
		dc.w		$090b
		dc.w		$0a00
		dc.w		$0b0f

H80x25:	dc.w		$0062
		dc.w		$0150
		dc.w		$0256
		dc.w		$0311
		dc.w		$0419
		dc.w		$0502
		dc.w		$0619
		dc.w		$0719
		dc.w		$0803
		dc.w		$090b
		dc.w		$0a00
		dc.w		$0b0f

H80x50:	dc.w		$0062
		dc.w		$0150
		dc.w		$0256
		dc.w		$0311
		dc.w		$0432
		dc.w		$0502
		dc.w		$0631
		dc.w		$0731
		dc.w		$0803
		dc.w		$090b
		dc.w		$0a00
		dc.w		$0b0f
*****  End Init Char and graph disp
		even
conDR 		equ		$f1c1c9
conSR			equ		$f1c1cd
ciRxRDY		equ		$1
coTxRDY		equ		$4

coStat:
	move.b	conSR,d0		* get status byte
	andi.w	#ciRxRDY,d0	* data available bit on?
	beq.b		csNotRDY		* branch if not
	moveq.l	#$1,d0		* set result to true
	rts

csNotRDY:
	clr.l	d0				* set result to false
	rts

* D0= Char that was input
coIn:
	move.l	a0,-(a7)

	tst.l		M400C0BA		* Dont input if no 400 card
	beq.w		coInRTN

ciNotRDY:
	bsr		coStat		* see if key pressed
	tst		d0
	beq		ciNotRDY		* wait until key pressed
	move.b	conDR,d0		* get key
	and.l		#$7f,d0		* clear all but low 7 bits
coInRTN:
	move.l 	(a7)+,a0
	rts
*   D1=char to output
coOut:
	move.l	a0,-(a7)

	tst.l		M400C0BA		* Dont output if no 400 card
	beq.w		coOutRTN

coNotRDY:
	move.b	conSR,d0		* get status
	and.b		#coTxRDY,d0		* check for transmitter buffer empty
	beq.b		coNotRDY		* wait until port ready...
	move.b	d1,conDR 		* and output it
coOutRTN:
	move.l 	(a7)+,a0
	rts					* and exit

* A0 -> string0  destroys D0,D1,A0
PRINTS:
	move.b	(a0)+,d1
	beq.b		prsDone
	bsr		coOut
	bra		PRINTS
prsDone:
	rts
NEWLINE:
	move.b	#13,d1
	bsr		coOut
	move.b	#10,d1
	bra		coOut
PSPACE:
	move.b	#' ',d1
	bra		coOut

tbHex:
	dc.b		'0123456789ABCDEF'
	even
cHexN:
	move.b	tbHex(pc,d1.w),d0
	rts

* print Hex value in D2 - destroys D0,D1
PHexB:
	move.w	d2,d1
	lsr.w		#4,d1
	and.l		#$0000000f,d1
	move.b	tbHex(pc,d1.w),d1
	bsr		coOut
	move.w	d2,d1
	and.l		#$0000000f,d1
	move.b	tbHex(pc,d1.w),d1
	bsr		coOut
	rts
PHexW:
	ror.w		#8,d2
	bsr.b		PHexB
	ror.w		#8,d2
	bsr.b		PHexB
	rts
PHexL:
	swap		D2
	bsr.b		PHexW
	swap		d2
	bsr.b		PHexW
	rts

* entry - stack has been pushed - InBuff.l, Count.W, OutBuff.l
*  d0 = count, d1 = byte, d2 = shifter/index 
cHexB:
	link		a6,#-2
	movem.l	d0/d1/d2/a0/a1,-(a7)

	move.l	8(a6),a1	*outbuff
	move.w	12(a6),d0	*count
	move.l	14(a6),a0	*in buff

cHexTop:
	tst.w		d0
	beq		cHexEx		
	move.b	(a0)+,d1	*get byte

	move.b	d1,d2
	lsr.w		#4,d2
	andi.w	#$f,d2
	move.b	tbHex(pc,d2.w),d2
	move.b	d2,(a1)+
	move.w	d1,d2
	andi.w	#$f,d2
	move.b	tbHex(pc,d2.w),d2
	move.b	d2,(a1)+

	subq.w	#1,d0
	bra		cHexTop

cHexEx:
	movem.l	(a7)+,d0/d1/d2/a0/a1
	unlk		a6
	rts

* enter with SP-> ex stack -4 due to BSR to here
* distroys A0 and D0 D1 D2 and D3
BSODBE:
	move.w	#8,VectOff
	bra.b 	BSODC
BSODAE:
	move.w	#$C,VectOff
	bra.b 	BSODC
BSOD:
	clr.w		VectOff
BSODC
	bsr.w		NEWLINE
	bsr.w		PRINTS

	tst.l		STACKS
	bne.b		not000	* not a 68000

	cmp.w		#8,VectOff
	bne.b		notBE		* not bus error
	bra.w		GOTF14
notBE:
	cmp.w		#$c,VectOff
	bne.b		notAE		* not Address error
	bra.w		GOTF14
notAE:
	bra.b		GOTF6		*must be a 3 word frame

not000:
	move.w	10(a7),d0
	lsr.w		#4,d0		*get format
	lsr.w		#8,d0		*get format - total of 12

	tst.b		d0
	bne.b		not0		* not format 0
	bra.b		GOTF8
not0:
	cmp.b		#2,d0
	bne.b		not2		* not format 2
	bra.b		GOTF12
not2:
	cmp.b		#8,d0
	bne.b		not8		* not format 8
	bra.w		GOTF58
not8:
	bra.b		GOTF8		*assume a 4 word frame
GOTF6:
	move.w	4(a7),d2	* SR
	bsr		PHexW
	bsr		PSPACE
	move.l	6(a7),d2	* PC
	bsr		PHexL
	bsr		NEWLINE
	rts
GOTF8:
	move.w	4(a7),d2	* SR
	bsr		PHexW
	bsr		PSPACE
	move.l	6(a7),d2	* PC
	bsr		PHexL
	bsr		PSPACE
	move.w	$a(a7),d2	* FVO
	bsr		PHexW
	bsr		NEWLINE
	rts
GOTF12:
	move.w	4(a7),d2	* SR
	bsr		PHexW
	bsr		PSPACE
	move.l	6(a7),d2	* PC
	bsr		PHexL
	bsr		PSPACE
	move.w	$a(a7),d2	* FVO
	bsr		PHexW
	bsr		PSPACE
	move.l	$c(a7),d2	* Instruction Address
	bsr		PHexL
	bsr		NEWLINE
	rts
GOTF14:
	move.w	4(a7),d2	* Extra Status (R/W,I/N,FCs)
	bsr		PHexW
	bsr		PSPACE
	move.l	6(a7),d2	* Fault Address
	bsr		PHexL
	bsr		PSPACE
	move.w	$a(a7),d2	* Instruction Register
	bsr		PHexW
	bsr		PSPACE
	move.w	$c(a7),d2	* SR
	bsr		PHexW
	bsr		PSPACE
	move.l	$e(a7),d2	* PC
	bsr		PHexL
	bsr		NEWLINE
	rts
GOTF58:	
	move.w	4(a7),d2	* SR
	bsr		PHexW
	bsr		PSPACE
	move.l	6(a7),d2	* PC
	bsr		PHexL
	bsr		PSPACE
	move.w	$a(a7),d2	* FVO
	bsr		PHexW
	bsr		PSPACE
	move.w	$c(a7),d2	* SSW
	bsr		PHexW
	bsr		PSPACE
	move.l	$e(a7),d2	* Fault Address
	bsr		PHexL
	bsr		PSPACE

* Data Input, Output Buffer, Instruction Buffer
	clr.w		d3
A58	move.w	$12(a7,d3.w),d2	
	bsr		PHexW
	bsr		PSPACE
	addq.w	#2,d3
	cmpi.w	#$c,d3
	bne.b		A58

	bsr		NEWLINE

	clr.w		d3
B58	move.w	$1e(a7,d3.w),d2	* 16 internal words
	bsr		PHexW
	bsr		PSPACE
	addq.w	#2,d3
	cmpi.w	#$20,d3
	bne.b		B58

	bsr	NEWLINE

	rts
*
* Jump Table BO routine
*
cmdBO:


rerror:
	lea	strBootF,a0
	bsr	PRINTS
	bra	*

strBootF:
	dc.b		'Boot Failed',13,10,0
strCRLF:
	dc.b		13,10,0
strBerr:
	dc.b		'Bus Error',13,10,0
strAerr:
	dc.b		'Address Error',13,10,0
strILL:
	dc.b		'Illegal',13,10,0
strDIv:
	dc.b		'Divide by Zero',13,10,0
strCHK:
	dc.b		'Bad Check',13,10,0
strTrapv:
	dc.b		'Trap v',' ','0',13,10,0
strPriv:
	dc.b		'Priviledge',13,10,0
strTrace:
	dc.b		'Trace',13,10,0
strLineA:
	dc.b		'LineA',13,10,0
strLineF:
	dc.b		'LineF',13,10,0

strFormat:
	dc.b		'Format',13,10,0

strTrap0:
	dc.b		'Trap 0',13,10,0
strTrap1:
	dc.b		'Trap 1',13,10,0
strTrap2:
	dc.b		'Trap 2',13,10,0
strTrap3:
	dc.b		'Trap 3',13,10,0
strTrap4:
	dc.b		'Trap 4',13,10,0
strTrap5:
	dc.b		'Trap 5',13,10,0
strTrap6:
	dc.b		'Trap 6',13,10,0
strTrap7:
	dc.b		'Trap 7',13,10,0
strTrap8:
	dc.b		'Trap 8',13,10,0
strTrap9:
	dc.b		'Trap 9',13,10,0
strTrap10:
	dc.b		'Trap 10',13,10,0
strTrap11:
	dc.b		'Trap 11',13,10,0
strTrap12:
	dc.b		'Trap 12',13,10,0
strTrap13:
	dc.b		'Trap 13',13,10,0
strTrap14:
	dc.b		'Trap 14',13,10,0
strTrap15:
	dc.b		'Trap 15',13,10,0
strUTrap15:
	dc.b		'Unsupported Trap 15 Function = ',0
strJMPbad:
	dc.b		'Unsupported Jump Table Function = ',0
strUnass:
	dc.b		'Unassigned',13,10,0
strUnassInt:
	dc.b		'Unassigned Interrupt',13,10,0
strSpurInt:
	dc.b		'Spurious Interrupt',13,10,0
strAutoInt:
	dc.b		'Auto vector Interrupt',13,10,0

	even

rBerr:
	lea		strBerr,a0
	bsr		BSODBE	
	bra		*
rAerr	
	lea		strAerr,a0
	bsr		BSODAE	
	bra		*
rILL	
	lea		strILL,a0
	bsr		BSOD	
	bra		*
rDIv
	lea		strDIv,a0
	bsr		BSOD	
	bra		*
rCHK
	lea		strCHK,a0
	bsr		BSOD	
	bra		*
rTrapv
	lea		strTrapv,a0
	bsr		BSOD	
	bra		*
rPriv
	lea		strPriv,a0
	bsr		BSOD	
	bra		*
rTrace
	lea		strTrace,a0
	bsr		BSOD	
	bra		*
rLineA
	lea		strLineA,a0
	bsr		BSOD	
	bra		*
rLineF
	lea		strLineF,a0
	bsr		BSOD	
	bra		*

rUnass:
	lea		strUnass,a0
	bsr		BSOD	
	bra		*

rFormat
	lea		strFormat,a0
	bsr		BSOD	
	bra		*

rUnInt
	lea		strUnassInt,a0
	bsr		BSOD	
	bra		*
rSpurInt
	lea		strSpurInt,a0
	bsr		BSOD	
	bra		*
rAv1
rAv2
rAv3
rAv4
rAv5
rAv6
rAv7
	lea		strAutoInt,a0
	bsr		BSOD	
	bra		*

rTrap0
	lea		strTrap0,a0
	bsr		BSOD	
	bra		*
rTrap1
	lea		strTrap1,a0
	bsr		BSOD	
	bra		*
rTrap2
	lea		strTrap2,a0
	bsr		BSOD	
	bra		*
rTrap3
	lea		strTrap3,a0
	bsr		BSOD	
	bra		*
rTrap4
	lea		strTrap4,a0
	bsr		BSOD	
	bra		*
rTrap5
	lea		strTrap5,a0
	bsr		BSOD	
	bra		*
rTrap6
	lea		strTrap6,a0
	bsr		BSOD	
	bra		*
rTrap7
	lea		strTrap7,a0
	bsr		BSOD	
	bra		*
rTrap8
	lea		strTrap8,a0
	bsr		BSOD	
	bra		*
rTrap9
	lea		strTrap9,a0
	bsr		BSOD	
	bra		*
rTrap10
	lea		strTrap10,a0
	bsr		BSOD	
	bra		*
rTrap11
	lea		strTrap11,a0
	bsr		BSOD	
	bra		*
rTrap12
	lea		strTrap12,a0
	bsr		BSOD	
	bra		*
rTrap13
	lea		strTrap13,a0
	bsr		BSOD	
	bra		*
rTrap14
	lea		strTrap14,a0
	bsr		BSOD	
	bra		*
T15JT 
	dc.l	rReset,T15bad,TBCOP1NL,T15bad,T15bad,T15bad,TBCOP1,T15bad 	*0-7
	dc.l	T15bad,T15bad,T15bad,T15bad,T15bad,T15bad,T15bad,T15bad	*8-f
* end tenbug table
* continue with vme133 bug table
	dc.l	DSKRD,T15bad,T15bad,T15bad,T15bad,T15bad,T15bad,T15bad	*10-17
	dc.l	T15bad,T15bad,T15bad,T15bad,T15bad,T15bad,T15bad,T15bad	*18-1f
	dc.l	T15bad,OUTSTR,OUTLN,T15bad,T15bad,T15bad,T15bad,T15bad	*20-27
	dc.l	T15bad,T15bad,T15bad,T15bad,T15bad,T15bad,T15bad,T15bad	*28-2f
	dc.l	T15bad,T15bad,T15bad,T15bad,T15bad,T15bad,T15bad,T15bad	*30-37
	dc.l	T15bad,T15bad,T15bad,T15bad,T15bad,T15bad,T15bad,T15bad	*38-3f
	dc.l	T15bad,T15bad,T15bad,T15bad,T15bad,T15bad,T15bad,T15bad	*40-47
	dc.l	T15bad,T15bad,T15bad,T15bad,T15bad,T15bad,T15bad,T15bad	*48-4f
	dc.l	T15bad,T15bad,T15bad,T15bad,T15bad,T15bad,T15bad,T15bad	*50-57
	dc.l	T15bad,T15bad,T15bad,T15bad,T15bad,T15bad,T15bad,T15bad	*58-5f
	dc.l	T15bad,T15bad,T15bad,rReset,T15bad,T15bad,T15bad,T15bad	*60-67
	dc.l	T15bad,T15bad,T15bad,T15bad,T15bad,T15bad,T15bad,T15bad	*68-6f
tvalue	equ		*-T15JT 
nfuncs	equ		tvalue/4



*   	fReturn = 63

rTrap15
	btst.b	#5,(a7)		*chk if caller from user or super
	sne.b		SupFlg		* FF if super, 00 if user
	clr.w		NPBytes		*clear number of parameter bytes to remove from stack
	move.w	(a7),StkSR
	move.l	2(a7),StkPC
	addq.l	#2,StkPC		*get rid of function
	move.w	6(a7),StkVO
	movem.l	d0-d7/a0-a6,SaveReg
	move.l	a7,SaveSSP
	move.l	usp,a0
	move.l	a0,SaveUSP
	

	move.l	2(a7),a0   		* a0 points to function
	move.w	(a0),d0		* d0 contains function
	move.w	d0,Funct

	cmp.w		#nfuncs,d0		* 
	bcc		T15bad
	lea		T15JT,a0		* a0 points to jump table
	lsl.w		#2,d0			* d0 x4 is offset to jump table
	movea.l	0(a0,d0.w),a0	* get address of routine from table
	jsr 		(a0)			* jump to function 
	
	move.w	NPBytes,d0
	tst.b		SupFlg
	bne.b		RTEsup
RTEuser
	move.l	SaveUSP,a0		* get rid of parms from user stack
	add.w		d0,a0
	move.l	a0,USP
	move.w	StkSR,(a7)
	move.l	StkPC,2(a7)
	move.w	StkVO,6(a7)
	bra.b		RTEexit
RTEsup
	add.w		d0,a7			*get rid of parms from super stack
	move.w	StkSR,(a7)
	move.l	StkPC,2(a7)
	move.w	StkVO,6(a7)
RTEexit
	movem.l	SaveReg,d0-d7/a0-a6
	rte

T15bad
	lea		strUTrap15,a0
	bsr		PRINTS
	move.w	Funct,D2
	bsr.w		PHexW
	bsr.w		NEWLINE
	bra	*
* Tenbug Trap 15 routines supported are 6-TBCOP1

* Output Line (with CR,LF)
* Input Parameters: A5.L -> Start Of String
*                   A6.L -> End Of String + 1
TBCOP1NL:
	bsr.w		TBCOP1
	bsr.w		NEWLINE
	clr.w		NPBytes
	rts

* Output Line (no CR,LF)
* Input Parameters: A5.L -> Start Of String
*                   A6.L -> End Of String + 1
TBCOP1:
	bsr.w		cOutStr
	clr.w		NPBytes
	rts

* pc=> function.w
*   	fDskrd  = 10
*  	fDskwr  = 11
* sp=>address of packet

* sp-> ret, SR, ret, VO, Addr of CmdPkt
* all registers are availible
DSKRD
	move.l	12(a7),a0
	move.l	a0,$f1a400
	move.w	#$10,$f1a404
	
*	tst.w		$f1a404
	tst.w		2(a0)
	move.w	ccr,d0
	move.w	StkSR,d1
	andi.w	#$ff00,d1
	or.w		d0,d1
	move.w	d1,StkSR

	move.w	#$4,NPBytes
	rts

*   	fOutstr = 21
*  	fOutln  = 22
* sp   => AofFC
* sp+4 => AofLC+1

* sp-> ret, SR, ret, VO, FC, LC+1
* all registers are availible
OUTSTR:
	move.l	12(a7),a5
	move.l	16(a7),a6

	bsr.w		cOutStr

	move.w	#$8,NPBytes
	rts

* sp-> ret, SR, ret, VO, FC, LC+1
* all registers are availible
OUTLN:
	move.l	12(a7),a5
	move.l	16(a7),a6

	bsr.w		cOutStr

	move.w	#13,D1
	jsr		coOut
	move.w	#10,D1
	jsr		coOut

	move.w	#$8,NPBytes
	rts

* output string A5->start A6->end+1
cOutStr:
	cmpa.l	a6,a5
	bcc		RetOSc
	move.b	(a5)+,d1
	jsr		coOut
	bra.b		cOutStr
RetOSc
	rts

*below are routines called by jmp table at $f0000C
JMPbad
	movem.l	d0-d2/a0,-(a7)
	lea		strJMPbad,a0
	bsr		PRINTS
	move.w	Funct,D2
	bsr.w		PHexW
	bsr.w		NEWLINE
	movem.l	(a7)+,d0-d2/a0
	rts

jTrace
	move.w	#$c,Funct
	jsr	JMPbad
	rts
jBOCMD
	move.w	#$10,Funct
	jsr	JMPbad
	jmp		rReset
jABORTB
	move.w	#$14,Funct
	jsr	JMPbad
	jmp		rReset
jCHKBP
	move.w	#$18,Funct
	jsr	JMPbad
	rts
jCHECKSUM
	move.w	#$1c,Funct
	jsr	JMPbad
	rts

* DSKCLUN	ds.b	1	* Controller Lun
* DSKDLUN	ds.b	1	* device Lun
* DSKSTSW	ds.w	1	* status word
* DSKMEM	ds.l	1	* DMA Memory
* DSKLSN	ds.l	1	* LSN 
* DSKNBLKS	ds.w	1	* number of blocks to read
* DSKAM	ds.w	1	* address modifier

jDISKR
* A0 = address of hardware (controller/drive)
* D0 = Number of 265 byte blks
* D1 = WD byte 5
* D2 = DMA
* D3 = LSN

	move.w	#$20,Funct

* set up DSKBLK
	move.w	d0,DSKNBLKS
	move.w	#0,DSKSTSW
	move.l	d2,DSKMEM
	move.l	d3,DSKLSN
	move.b	IPCNUM,DSKCLUN
	move.b	DRVNUM,DSKDLUN
	move.w	#0,DSKAM
* do the read
	lea		DSKBLK,a0
	move.l	a0,$f1a400
	move.w	#$10,$f1a404
	
*	tst.w		$f1a404
	tst.w		2(a0)
* return with CCR set to status conditions
	rts

jDISKW
	move.w	#$24,Funct

* set up DSKBLK
	move.w	d0,DSKNBLKS
	move.w	#0,DSKSTSW
	move.l	d2,DSKMEM
	move.l	d3,DSKLSN
	move.b	IPCNUM,DSKCLUN
	move.b	DRVNUM,DSKDLUN
	move.w	#0,DSKAM
* do the read
	lea		DSKBLK,a0
	move.l	a0,$f1a400
	move.w	#$11,$f1a404
	
*	tst.w		$f1a404
	tst.w		2(a0)
* return with CCR set to status conditions
	rts

jINITVECT
	move.w	#$28,Funct
	jsr	JMPbad
	rts
jINITHRAM
	move.w	#$2c,Funct
	jsr	JMPbad
	rts
jINCHS
	move.w	#$30,Funct
	jsr		coIn
	rts
jOUTCHS
	move.w	#$34,Funct
	movem.l	d0/d1,-(a7)
	move.w	d0,d1
	jsr		coOut
	movem.l	(a7)+,d0/d1
	rts
jPOINTRAM
	move.w	#$38,Funct
	lea		PTRRAM,A0
	rts
jNA3C
	move.w	#$3c,Funct
	jsr	JMPbad
	bra.w	*
jHOTSTART
	move.w	#$40,Funct
	jmp		rReset
jNA44
	move.w	#$44,Funct
	jsr	JMPbad
	bra.w	*
jNA48
	move.w	#$48,Funct
	jsr	JMPbad
	bra.w	*

DevPr:
	move.l	8,-(sp)
	move.l	#ndber,8
	tst.b		(a0)
	move.l	(sp)+,8
	rts
ndber:
	suba.l 	a0,a0
	add.l		#58,sp
	move.l	(sp)+,8
	rts

* 
*	Disk IO using LSN DC
*

* controller number in D0
SELIPC:
	move.b	D0,IPCNUM
	rts

* drive number in D0 
SELDSK:
	move.b	D0,DRVNUM
	rts

* LSN in D0
SETLSN:
	move.l	D0,LSNNUM
	rts

* NUMLSN in D0
	move.w	D0,NUMLSN
	rts

* DMA ADDRESS in D0
SETDMA:
	move.l	D0,DMAADD
	rts

* DSKCLUN	ds.b	1	* Controller Lun
* DSKDLUN	ds.b	1	* device Lun
* DSKSTSW	ds.w	1	* status word
* DSKMEM	ds.l	1	* DMA Memory
* DSKLSN	ds.l	1	* LSN 
* DSKNBLKS	ds.w	1	* numberr of blocks to read
* DSKAM	ds.w	1	* address modifier

READDSK:
* set up DSKBLK
	jsr	COMDSK
* do the Read
	move.w	#$10,$f1a404
	tst.w		DSKSTSW-DSKBLK(A0)
* return with CCR set to status conditions and A0->DSKBLK
	rts

WRITEDSK:
* set up DSKBLK
	jsr	COMDSK
* do the Write
	move.w	#$11,$f1a404
	tst.w		DSKSTSW-DSKBLK(A0)
* return with CCR set to status conditions and A0->DSKBLK
	rts

COMDSK:
* set up DSKBLK
	lea		DSKBLK,a0
	move.w	NUMLSN,DSKNBLKS-DSKBLK(A0)
	move.w	#0,DSKSTSW-DSKBLK(A0)
	move.l	DMAADD,DSKMEM-DSKBLK(A0)
	move.l	LSNNUM,DSKLSN-DSKBLK(A0)
	move.b	IPCNUM,DSKCLUN-DSKBLK(A0)
	move.b	DRVNUM,DSKDLUN-DSKBLK(A0)
	move.w	#0,DSKAM-DSKBLK(A0)
* set up for read/write
	move.l	a0,$f1a400
	rts
