/* DROPZONE version 1.0 for VMEs10 emulator*/

/* Changes
 made it required to supply drive.
 fixed lastdrive to be p instead of z

 ported to Vme10 emulator

 compile with Alcyon C for CPM68k
*/

#include <stdio.h>
#include <ctype.h>

FILE *fopen();
FILE *fopena();
FILE *fopenb();

/*
$F1A060 - $F1A06f

| even  | Odd  |
|     word     |
RegDZ + offset offset 

00:01:	Dropzone File Count/Set Current File
	(write zero to reset DropZone)
02:03: 	DropZone Windows File Name byte (read until NULL)
04:05: 	DropZone CPM File Name byte  (read until NULL)
06:07: 	DropZone FileSize High Word(Big End-ian)
08:09: 	DropZone FileSize Low Word
0a:0b: 	DropZone Status Input/Control 0=NOT EOF, 1=EOF 
0c:0d: 	DropZone Data Input
*/
#define DZFCNT ((char *)0xf1a061)
#define DZWNAME ((char *)0xf1a063)
#define DZENAME ((char *)0xf1a065)
#define DZFSZ ((unsigned long *)0xf1a066)
#define DZCTRL ((char *)0xf1a06b)
#define DZSTS ((char *)0xf1a06b)
#define DZDATA ((char *)0xf1a06d)

main(argc,argv)
int argc;
char **argv;
{

int Function;
int i;
int f;
int Usage;
int FileCnt;
int DZFileCnt;
int RTN;

char BufDriveSpec[5];      /* only used when listing and is NULL*/
char BufDZCpmFileName[20]; /* "01234567.012"    */
char BufDZWinFileName[1024]; 
char BufNewFileName[20];   /* "00x:01234567.012"  */

char *DZCpmFileName;     
char *DZWinFileName;
char *NewFileName;
char *DriveSpec;

char *tempArg;

unsigned long DZFileSize;
unsigned DZRecords;
unsigned DZBytes;

DZCpmFileName=BufDZCpmFileName;
DZWinFileName=BufDZWinFileName;
NewFileName=BufNewFileName;
DriveSpec=BufDriveSpec;

DZCpmFileName[0]=0;
DZWinFileName[0]=0;
NewFileName[0]=0;
DriveSpec[0]=0;

Usage=0;
Function=0;
/*
printf ("Number of Arguments = %d\n", argc);
for ( i=0 ; i < argc ; i++ )
{
printf (" argv[%d]= %s\n",i,argv[i]);
}
*/
if(argc > 2) Usage++;

if (argc == 2)
	{
	tempArg=argv[1];
	i=0; while (tempArg[i]!=0){ tempArg[i]=toupper(tempArg[i]); i++;} 
	if ( strcmp(tempArg,"LIST")==0 ) Function=1; 
	if ( strcmp(tempArg,"RESET")==0 ) Function=2; 
	switch (Function)
	  {
	   case 0:
		DriveSpec=argv[1];
		switch ( strlen(DriveSpec) )
		  {
		    case 2:
			if ( (DriveSpec[0] < 'A') || (DriveSpec[0] > 'P') ) Usage++;
			if ( (DriveSpec[1] != ':') ) Usage++;
			break;
		    case 3:
			if ( (DriveSpec[0] < '0') || (DriveSpec[0] > '9') ) Usage++;
			if ( (DriveSpec[1] < 'A') || (DriveSpec[1] > 'P') ) Usage++;
			if ( (DriveSpec[2] != ':') ) Usage++;
			break;
		    case 4:
			switch (DriveSpec[0] )
			  {
				case '0':
				  if ( (DriveSpec[1] < '0') || (DriveSpec[1] > '9') ) Usage++;
				  if ( (DriveSpec[2] < 'A') || (DriveSpec[2] > 'P') ) Usage++;
				  if ( (DriveSpec[3] != ':') ) Usage++;
				  break;
				case '1':
				  if ( (DriveSpec[1] < '0') || (DriveSpec[1] > '5') ) Usage++;
				  if ( (DriveSpec[2] < 'A') || (DriveSpec[2] > 'P') ) Usage++;
				  if ( (DriveSpec[3] != ':') ) Usage++;
				  break;
				default:
				  Usage++;
				  break;
			  }
			break;
		    default:
			 Usage++;
			 break;
		  }
		break;
	   case 1:  /* LIST */
		DriveSpec=argv[1];
		DriveSpec[0]='X';
		DriveSpec[1]=':';
		DriveSpec[2]=0;
		break;
	   case 2: /* RESET */
		*DZFCNT = 0 ;
		exit();
	  }
	}
else Usage++;

printf("\n Dropzone Version 1.0 for CPM68k on VMEs10 Emulator\n");

DZFileCnt = *DZFCNT ;

if (DZFileCnt==0)
	{
	printf("\n  Drop Zone is Empty\n");
	printf("\n  Drag some files from Explorer to the Drop Zone before running DropZone\n");
	Usage++;
	}

if (Usage != 0)	
	{	
	printf("\n   Usage: DropZone [<user>]<Drive>: | RESET | LIST <cr>\n");
/*	printf("\n      can not use default for drive\n"); */
	exit();
	}

FileCnt=0;

for ( f=1 ; f<=DZFileCnt ; f++ )
{
	*DZFCNT = f ;

	DZFileSize = *DZFSZ ;
	DZRecords = (DZFileSize / 128 ) ;
	DZBytes = DZFileSize % 128;

	GetDZCpmFileName(DZCpmFileName);
	GetDZWinFileName(DZWinFileName);

	NewFileName[0]=0;

	strcat(NewFileName,DriveSpec);
	strcat(NewFileName,&DZCpmFileName[0]);
	i=0; while ( (NewFileName[i]!=' ') && (NewFileName[i]!='.') ) i++;
	NewFileName[i]=0;
	strcat(NewFileName,&DZCpmFileName[8]);

	switch (Function)
	{
	   case 0:
		printf("\nProcessing File - %s\n",NewFileName);
		printf(" %s\n",DZWinFileName);
		if (DZFileSize  > 8388608)
		{
			printf("  File greater than 8MB - skipping...\n");
		}
		else
		{
			printf("  %u records + %u bytes\n",DZRecords,DZBytes);
			RTN=DloadFile(NewFileName);
			switch (RTN)
			{ 
			case 0:
				FileCnt++;
				break;
			case -1:
				printf("Download error");
			/*	printf("Download error: %s n",errmsg(errno())); */
				break;
			}
		}
		break;
	   case 1:
		printf("Listing File - %s\n",NewFileName);
		printf(" %s\n",DZWinFileName);
		if (DZFileSize  > 8388608)
		{
			printf("  File greater than 8MB\n");
		}
		else
		{
			printf("  %u records + %u bytes\n",DZRecords,DZBytes);
		}
		FileCnt++;
		break;
	}
}

switch (Function)
{
   case 0:
	printf("\nDone - %d Files Written",FileCnt);
	printf("\n       %d Files Skipped\n",DZFileCnt-FileCnt);
	*DZFCNT = 0 ;  /* RESET the Drop Zone */
	break;
   case 1:
	printf("\nDone - %d Files Listed\n",FileCnt);
	break;
}

exit();

}


GetDZCpmFileName(NewFileName)
char *NewFileName;
{
int i;
int InByte;
i=0;

do{
  InByte = *DZENAME ;
  NewFileName[i]=InByte;
  i++;
}while (InByte!=0);

return(i);
}

GetDZWinFileName(NewFileName)
char *NewFileName;
{
int i;
int InByte;
i=0;

do{
  InByte = *DZWNAME ;
  NewFileName[i]=InByte;
  i++;
}while (InByte!=0);

return(i);
}
 

DloadFile(CPMfileName)
char *CPMfileName;
{
FILE *fp;
int cntz;
int InByte;
int fd;
int RecCnt;

if( (fd = open(CPMfileName,0)) == -1 )
{
   if( (fd = creatb(CPMfileName,1)) == -1 )
	{
	 printf("\nCan't Create %s\n",CPMfileName);
   	 return(-1);
	} 
   close(fd);
}
else
{
   close(fd);
   printf(" File Exists - Overwrite? (Y or N) - ");
   InByte=getchar();
   printf("\n");
   if ( (InByte != 'Y') && (InByte != 'y' ) ) return(-2);
}

if( (fp = fopenb(CPMfileName,"w"))==NULL ) 	
{
   printf("\nCan't open %s\n",CPMfileName);
   return(-1);
}
printf(" Downloading...");

cntz=0x80;
RecCnt=0;

*DZCTRL = 0xff ; /* rewind NOT implememnted*/

while (*DZSTS == 0) /* NOT EOF*/
{
	InByte = *DZDATA ;
	if (*DZSTS == 0) /* NOT EOF*/
	{
	 if (fputc(InByte,fp) == -1) return(-1);
	 cntz--;
	 if (cntz==0){ cntz=0x80; RecCnt++; }
	};
}
while (cntz !=0 && cntz !=0x80) 
{
 fputc(0x1a,fp); cntz--; 
 if (cntz==0)RecCnt++;
}

fclose(fp);

printf(" Finished\n%d Records Written\n",RecCnt);

return(0);
}