
; Some basic code for driving LCD alphanumeric displays. It is mostly to
; demonstrate that these LCDs could be driven by a Z80 without complex ports
; or timing problems.

; Interface equates. Note C2h and C3h are read ONLY.

WRINST	EQU	C0h		; write instruction
WRDATA	EQU	C1h		; write data
RDBUSY	EQU	C2h		; read busy flag (and address)
RDDATA	EQU	C3h		; read data

	ORG	1800h		; start in RAM

	LD	B,#0		; initial delay
	DJNZ	$		; do it

	LD	HL,INITBL	; start table
	LD	B,#15		; 15 mS delay
	CALL	INSTR		; output instruction
	LD	B,#5		; 5 mS delay
	CALL	INSTR		; output instruction
	LD	B,#1		; 1 mS delay
	CALL	INSTR		; output instruction

	LD	B,#4		; 4 mode bytes
MODSET:
	CALL	BUSY		; wait until ready
	INC	HL		; point to first mode byte
	LD	A,(HL)		; get byte
	OUT	(WRINST),A	; out to display
	DJNZ	MODSET		; loop until all done

	LD	HL,MESSAGE	; point to the message
	CALL	BUSY		; wait until ready
	LD	A,#0Fh		; display on, cursor blink
	OUT	(WRINST),A	; out to display
	LD	A,#80h		; address set to 00
	CALL	MESG		; send the message

	HALT			; all stop

MESG:
	CALL	BUSY		; wait until ready
	OUT	(WRINST),A	; address out to display
	LD	B,#MSGEND-MESSAGE	; mesage length	
WRITE2:
	CALL BUSY		; wait until ready
	LD	A,(HL)		; get byte
	OUT	(WRDATA),A	; chr out to display
	INC	HL		; point to next chr
	DJNZ	WRITE2		; loop until all chrs done

	RET

BUSY:				; wait until ready:
	PUSH	AF		; save AF
BUSY1:
	IN	A,(RDBUSY)	; get status (& address)
	BIT	7,A		; check status bit
	JR	NZ,BUSY1	; loop if still busy
	POP	AF		; restore AF
	RET			; done

INSTR:				; output instruction
	CALL	DELAY		; wait for B mS
	LD	A,(HL)		; get byte
	OUT	(WRINST),A	; out to display
	RET			; done

DELAY:
	PUSH	HL		; save HL
	LD	DE,-1		; set to -1
LOOP1:
	LD	HL,431/5	; 86
LOOP2:
	ADD	HL,DE		; decrement HL
	JR	C,LOOP2		; loop if not 0
	DJNZ	LOOP1		; decrement mS count & loop if not 0
	POP	HL		; restore HL
	RET			; done

INITBL:
	DB	30h		; initialisation byte (set 8 bit I/F)
	DB	38h		; set 8 bit I/F, 2 lines, 5x7 font.
	DB	08h		; display off
	DB	01h		; clear & home display
	DB	06h		; set no scroll, cursor shifts right.

MESSAGE:
	DB	'LCD Display'	; any old rubbish
MSGEND:

	END
