

;********************* RAM VARIABLES ************************************


             .ORG    $8000

SER_STRING:  .DS     20             ; MODTAGET TEKST FRA SER. PORT
SER_POINT:   .DS     1              ; POINTER TIL SER_STRING.
SER_ON:      .DS     1              ; OUTPUT TIL SER 1=ON 0=OFF
SER_BAUD:    .DS     1              ; 1=1200
UARTFEJL:    .DS     1              ; 1=FEJL 0=OK
DEBUG:       .DS     1              ; 1=ON   0=OFF



;********************* IO ADRESSER ***************************************
PIOA:        .EQU    0              ; (INPUT) 0-3=KEYS 4=POL 5=TEMP 6=ADCBUSY
PIOB:        .EQU    1              ; (IN/OUT) LCD-DISPLAY DATA
PIOC:        .EQU    2              ; (OUTPUT) 0-3=DISPLAY-CONTROL, 4-7=KEYS
PIOCONT:     .EQU    3              ; CONTROL AF PIO

UART0:       .EQU    8              ; DATA IN/OUT
UART1:       .EQU    9              ; CHECK RX
UART2:       .EQU    10             ; INTERRUPTS
UART3:       .EQU    11             ; LINE CONTROL
UART4:       .EQU    12             ; MODEM CONTROL 0=soff 1=rel 2=convert
UART5:       .EQU    13             ; LINE STATUS
UART6:       .EQU    14             ; MODEM STATUS
UART7:       .EQU    15             ; SCRATCH REG.

DACSTR0M:    .EQU    16             ; StrmGenerator
DACLYD:      .EQU    17             ; Hjttaler
ADC:         .EQU    24             ; MleSpnding



;******************************************************************
;        INIT_UART                                                ;
;        Funktion....: Initialisere seriel  8250, 16450, 16550    ;
;                      9600 Baud, 8 bit, 1 stopbit, 0 paritet     ;
;        Output......:                                            ;
;        delgger...: A,                                         ;
;        Kalder......: PAUSE                             TST 1993 ;
;******************************************************************
INIT_UART:   LD     A,$AA
             OUT    (UART7),A
             IN     A,(UART7)
             CP     $AA           ; Test om vrdien kunne gemmes
             JP     NZ,INITUARTFEJL
             LD     A,$55
             OUT    (UART7),A
             IN     A,(UART7)
             CP     $55           ; Test om vrdien kunne gemmes
             JP     NZ,INITUARTFEJL
             JP     UART_OK

INITUARTFEJL:                      ; Her er der fejl i UART
             LD     A,0
             LD     (SER_ON),A     ; SLUK SERPORT
             CALL   CLS
             LD     HL,TXT_UART1A  ; FEJL BESKED
             CALL   SKRIV
             LD     BC,10000
             CALL   PAUSE
             LD     A,1
             LD     (UARTFEJL),A
.IF LAVFINAL=1
             HALT
.ENDIF
             JP     INITRET



UARTFEJLDEF:
             LD     A,0
             LD     (SER_ON),A     ; SLUK SERPORT
             CALL   CLS
             LD     HL,TXT_UART2   ; FEJL BESKED "BAUD RATE IKKE DEFINERET"
             CALL   SKRIV          ;              VLGER 19K2
             LD     BC,60000
             CALL   PAUSE
             JP     UART19K2

UART_OK:     LD     A,0
             LD     (UARTFEJL),A   ; UART OK FUNDET
             LD     A,(SER_BAUD)
             CP     1
             JP     Z,UART1200
             CP     2
             JP     Z,UART2400
             CP     3
             JP     Z,UART4800
             CP     4
             JP     Z,UART9600
             CP     5
             JP     Z,UART19K2
             CP     6
             JP     Z,UART38K4
             CP     7
             JP     Z,UART57K6
             CP     8
             JP     Z,UART76K8
             JP     UARTFEJLDEF

UART1200:    LD     A,80H
             OUT    (UART3),A     ; SET DLAB FLAG
             LD     A,218         ; (218.45)
             OUT    (UART0),A     ;
             LD     A,00H
             OUT    (UART1),A     ;
             LD     A,03H
             OUT    (UART3),A     ; Set 8 bit data, 1 stopbit
             JP     INITRET       ; 0 paritet, reset DLAP FLAG
UART2400:    LD     A,80H
             OUT    (UART3),A     ; SET DLAB FLAG
             LD     A,109         ; (109.23)
             OUT    (UART0),A     ;
             LD     A,00H
             OUT    (UART1),A     ;
             LD     A,03H
             OUT    (UART3),A     ; Set 8 bit data, 1 stopbit
             JP     INITRET       ; 0 paritet, reset DLAP FLAG
UART4800:    LD     A,80H
             OUT    (UART3),A     ; SET DLAB FLAG
             LD     A,55          ; (54.61)
             OUT    (UART0),A     ;
             LD     A,00H
             OUT    (UART1),A     ;
             LD     A,03H
             OUT    (UART3),A     ; Set 8 bit data, 1 stopbit
             JP     INITRET       ; 0 paritet, reset DLAP FLAG
UART9600:    LD     A,80H
             OUT    (UART3),A     ; SET DLAB FLAG
             LD     A,27          ; (27.3)
             OUT    (UART0),A     ; Set BAUD rate til 9600
             LD     A,00H
             OUT    (UART1),A     ; Set BAUD rate til 9600
             LD     A,03H
             OUT    (UART3),A     ; Set 8 bit data, 1 stopbit
             JP     INITRET       ; 0 paritet, reset DLAP FLAG
UART19K2:    LD     A,80H
             OUT    (UART3),A     ; SET DLAB FLAG
             LD     A,14          ; (13.65)
             OUT    (UART0),A     ;
             LD     A,0
             OUT    (UART1),A     ;
             LD     A,3
             OUT    (UART3),A     ; Set 8 bit data, 1 stopbit
             JP     INITRET       ; 0 paritet, reset DLAP FLAG
UART38K4:    LD     A,80H
             OUT    (UART3),A     ; SET DLAB FLAG
             LD     A,7
             OUT    (UART0),A     ; (6.82)
             LD     A,00H
             OUT    (UART1),A     ;
             LD     A,03H
             OUT    (UART3),A     ; Set 8 bit data, 1 stopbit
             JP     INITRET       ; 0 paritet, reset DLAP FLAG
UART57K6:    LD     A,80H
             OUT    (UART3),A     ; SET DLAB FLAG
             LD     A,5
             OUT    (UART0),A     ; (4.55)
             LD     A,00H
             OUT    (UART1),A     ;
             LD     A,03H
             OUT    (UART3),A     ; Set 8 bit data, 1 stopbit
             JP     INITRET       ; 0 paritet, reset DLAP FLAG
UART76K8:    LD     A,80H
             OUT    (UART3),A     ; SET DLAB FLAG
             LD     A,3
             OUT    (UART0),A     ; (3.41)
             LD     A,00H
             OUT    (UART1),A     ;
             LD     A,03H
             OUT    (UART3),A     ; Set 8 bit data, 1 stopbit
                                  ; 0 paritet, reset DLAP FLAG
INITRET:     RET




;******************************************************************
;        TX_SER                                                   *
;        Funktion....: transmit text and data on serial port      *
;        Input.......: HL points to text start adresse            *
;        Output......: Tekst on serielport                        *
;        uses........: A,HL                                       *
;        Kalder......: TX_BUSY                      tst 28-4-1994 *
;******************************************************************
TX_SER:      PUSH   AF
             LD     A,(SER_ON)     ; HVIS COM ER OFF
             CP     0              ; SKRIVES DER IKKE..
             JP     Z,TX_SLUT
TX_SERLP:    LD     A,(HL)         ; Hent karakter til A
             CP     $ff            ; Test om teksten er slut
             JP     Z,TX_SLUT      ; Hop til TX SLUT hvis teksten er slut
             CALL   TX_BUSY        ; vent p uart er klar
             OUT    (UART0),A      ; Skriv karakter p serielporten
             INC    HL
             JP     TX_SERLP       ; Hop til TX LOOP
TX_SLUT:     POP    AF
             RET



;******************************************************************
;        RX_BUSY                                                  *
;        Funktion....: wait for UART has data in rx buffer        *
;        Input.......: Bit 0 in UART'ens MODEM KONTROL REGISTER  *
;******************************************************************
RX_BUSY:     PUSH   AF
RX_BUSYLP:   IN     A,(UART5)      ; Ls Line Status Register
             BIT    0,A            ; Test om der er modtaget data
             JP     Z,RX_BUSYLP    ; vent til der er data
             POP    AF
             RET


;******************************************************************
;        TX_BUSY                                                  *
;        Funktion....: wait for UART TX buffer ready              *
;        Input.......: Bit 5 in UART MODEM KONTROL REGISTER       *
;******************************************************************
TX_BUSY:     PUSH   AF
TX_BUSYLP:   IN     A,(UART5)     ; read Line Status Register
             BIT    5,A           ; Test if UART are ready to send
             JP     Z,TX_BUSYLP   ; wait until tx-buffer is ready
             POP    AF
             RET

NYLINJE:     LD     A,$0A        ; new line
             CALL   TX_BUSY
             OUT    (UART0),A
             LD     A,$0D
             CALL   TX_BUSY
             OUT    (UART0),A
             RET






;*********************************************************************
;*        SUB-RUTINE..: SERIAL                                       *
;*        Funktion....: CONTROLS INPUT FROM IBM-PC CALLED FROM INTERRUPT *
;*        Input.......: POINTER TO TXT: SER_POINT                   *
;*        Output......: RECIEVED TEXT IN: SER_STRING                  *
;*        USES........: A,BC,HL                                      *
;*        Calles......: TX_BUSY                                      *
;*        Initialer...: TST. dato: 3/1-96                            *
;*********************************************************************
SERIAL:      LD     A,(SER_ON)     ; IF COM IS OFF
             CP     0              ; then just end, the serial controll
             JP     Z,SERIAL_END
             IN     A,(UART5)      ; read Line Status Register
             BIT    0,A            ; Test if data is in recieve buffer
             JP     Z,SERIAL_END   ; end if no data in BUFFER.
             IN     A,(UART0)      ; get valid data
             CP     $0D
             JP     Z,SER_RETURN   ; HVIS DER ER TRYKKET RETURN, INTET ECHO
             CALL   TX_BUSY
             OUT    (UART0),A      ; ECHO
             LD     B,A            ; GEM MODTAGET KARAKTER

             LD     HL,SER_STRING  ; MODTAGET TEKST STRENG
             LD     A,(SER_POINT)  ; POINTER TIL HVOR DER SKAL GEMMES
SER_LP1:     INC    HL             ; INC HL, A ANTAL GANGE
             DEC    A
             JP     NZ,SER_LP1
             LD     A,B            ; HENT MODTAGET DATA
             LD     (HL),A         ; GEM KARAK. I STRING.
             LD     A,(SER_POINT)
             INC    A
             LD     (SER_POINT),A  ; PEG P NSTE PLADS
             CP     20
             JP     Z,SER_RETURN   ; HVIS 20 KARAKTERE LANG, S NULSTIL.
SERIAL_END:  RET

SER_RETURN:  LD     A,(DEBUG)
             CP     1
             JP     Z,DEBUG_ON
             LD     A,(HELP)
             CP     1
             JP     Z,HELP_ON       ; hvis on, s sl help fra.

             LD     B,'1'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'4'           ; LINJE ENER
             LD     E,'0'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC
             LD     HL,TX_PROMPT    ; lav ny prompt
             CALL   TX_SER          ; og slet alt indtastet
             LD     B,'4'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'4'           ; LINJE ENER
             LD     E,'0'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC

             LD     HL,SER_STRING+1 ; modtaget tekst
             LD     BC,COM_RESET    ; HER ER KOMANDOEN
             CALL   SER_COMPARE
             CP     $FF
             JP     Z,SER_RESET     ; HVIS INPUT PASSER TIL COM_RESET  S..

             LD     HL,SER_STRING+1 ; modtaget tekst
             LD     BC,COM_HELP1    ; HER ER KOMANDOEN
             CALL   SER_COMPARE
             CP     $FF
             JP     Z,SER_HELP      ; HVIS INPUT PASSER TIL COM_RESET  S..

             LD     HL,SER_STRING+1 ; modtaget tekst
             LD     BC,COM_HELP2    ; HER ER KOMANDOEN
             CALL   SER_COMPARE
             CP     $FF
             JP     Z,SER_HELP      ; HVIS INPUT PASSER TIL COM_RESET  S..

             LD     HL,SER_STRING+1 ; modtaget tekst
             LD     BC,COM_DEBUG    ; HER ER KOMANDOEN
             CALL   SER_COMPARE
             CP     $FF
             JP     Z,SER_DEBUG     ; HVIS INPUT PASSER TIL COM_RESET  S..

SERIAL_REND: CALL   SER_SLET
             JP     SERIAL_END

;HER STR DE KOMANDOER DER DUER

COM_RESET:   .BYTE "RESET",$FF      ; SER_RESET
COM_DEBUG:   .BYTE "DEBUG",$FF      ;
COM_Q:       .BYTE "Q",$FF          ; QUIT DEBUGER
COM_H:       .BYTE "?",$FF          ; HELP DEBUG  MODE
COM_D:       .BYTE "D",$FF          ; DUMP ADRESSE
COM_HELP1:   .BYTE "H",$FF          ; HELP NORMAL MODE
COM_HELP2:   .BYTE "?",$FF          ; HELP NORMAL MODE
COM_E:       .BYTE "E",$FF          ; EDIT

COM_DL:      .BYTE "DOWNLOAD",$FF   ;
COM_UL:      .BYTE "UPLOAD",$FF     ;

SER_RESET:   CALL   SER_SLET
             LD     HL,TX_RESET
             CALL   TX_SER
             JP     0

SER_HELP:    LD     A,1
             LD     (HELP),A        ; MARKER HELP ER ON
             LD     B,'1'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'4'           ; LINJE ENER
             LD     E,'0'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC
             LD     HL,TX_PROMPT
             CALL   TX_SER
             CALL   SER_SLET
             LD     B,'1'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'6'           ; LINJE ENER
             LD     E,'0'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC
             LD     HL,TX_HELP
             CALL   TX_SER          ; SKRIV DEBUG HELP SCREEN
             LD     B,'4'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'4'           ; LINJE ENER
             LD     E,'0'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC
             JP     SERIAL_END


SER_DEBUG:   CALL   SER_SLET
             LD     B,'1'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'6'           ; LINJE ENER
             LD     E,'0'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC
             LD     HL,TX_DEBUG
             CALL   TX_SER          ; SKRIV DEBUG HELP SCREEN
             LD     A,1
             LD     (DEBUG),A       ; DEBUG ER NU ON
             LD     B,'1'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'5'           ; LINJE ENER
             LD     E,'1'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC
             LD     HL,TX_D_PROMPT  ; DEBUG PROMPT
             CALL   TX_SER
             LD     B,'2'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'5'           ; LINJE ENER
             LD     E,'1'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC
             JP     SERIAL_END

HELP_ON:     LD     A,0
             LD     (HELP),A        ; SL HJELP FRA
             JP     SER_Q           ; SLET SKRM

DEBUG_ON:    LD     A,(DEBUG_EDIT)
             CP     1
             JP     Z,EDIT_DAT_IND

             LD     B,'1'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'5'           ; LINJE ENER
             LD     E,'1'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC
             LD     HL,TX_D_PROMPT  ; DEBUG PROMPT
             CALL   TX_SER
             LD     B,'2'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'5'           ; LINJE ENER
             LD     E,'1'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC

             LD     HL,SER_STRING+1 ; modtaget tekst
             LD     BC,COM_Q        ; Q = QUIT
             CALL   SER_COMPARE
             CP     $FF
             JP     Z,SER_Q         ; HVIS INPUT PASSER TIL COM_RESET  S..

             LD     HL,SER_STRING+1 ; modtaget tekst
             LD     BC,COM_H        ; ? = HELP
             CALL   SER_COMPARE
             CP     $FF
             JP     Z,SER_DEBUG     ; HVIS INPUT PASSER TIL COM_RESET  S..

             LD     HL,SER_STRING+1 ; modtaget tekst
             LD     BC,COM_D        ; ? = HELP
             CALL   SER_COMPARE
             CP     $FF
             JP     Z,SER_DUMP      ; HVIS INPUT PASSER TIL COM_RESET  S..

             LD     HL,SER_STRING+1 ; modtaget tekst
             LD     BC,COM_E        ; E = EDIT
             CALL   SER_COMPARE
             CP     $FF
             JP     Z,SER_EDIT      ; HVIS INPUT PASSER TIL COM_RESET  S..

             CALL   SER_SLET
             JP     SERIAL_END


SER_EDIT:    LD     A,$0C          ; CLEAR SCREEN KODEN
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.

             LD     B,'0'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'7'           ; LINJE ENER
             LD     E,'1'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC
             LD     HL,SER_STRING+1 ; HER STARTER START ADR.
EDI_DU_FIND: INC    HL
             LD     A,(HL)
             CALL   CHK_ASCII       ; B=ASCII C=HEX A=OK ELLER TALLET
             CP     $FF             ; FEJL IKKE 0-9 ELLER A-F
             JP     Z,EDI_DU_FIND
             LD     A,B             ; OK FUNDET GODT TAL.
             LD     (DUMP_A_ASC),A  ; GEM 1. KARAK I ADRESSEN
             LD     A,C             ; OK FUNDET GODT TAL.
             SCF
             CCF
             RLCA
             RLCA
             RLCA
             RLCA
             LD     (DUMP_A_BIN+1),A  ; GEM MEST BETYD NIBBLE

             INC    HL
             LD     A,(HL)
             CALL   CHK_ASCII       ; B=ASCII C=HEX A=OK ELLER TALLET
             CP     $FF             ; FEJL IKKE 0-9 ELLER A-F
             JP     Z,EDI_DU_FIND
             LD     A,B             ; OK FUNDET GODT TAL.
             LD     (DUMP_A_ASC+1),A  ; GEM 2. KARAK I ADRESSEN
             LD     A,(DUMP_A_BIN+1)  ; HENT MEST BETYD NIBBLE
             ADD    A,C               ; ADDER DE TO NIBBLER
             LD     (DUMP_A_BIN+1),A  ; GEM MEST BETYD BYTE

             INC    HL
             LD     A,(HL)
             CALL   CHK_ASCII       ; B=ASCII C=HEX A=OK ELLER TALLET
             CP     $FF             ; FEJL IKKE 0-9 ELLER A-F
             JP     Z,EDI_DU_FIND
             LD     A,B             ; OK FUNDET GODT TAL.
             LD     (DUMP_A_ASC+2),A  ; GEM 3. KARAK I ADRESSEN
             LD     A,C             ; OK FUNDET GODT TAL.
             SCF
             CCF
             RLCA
             RLCA
             RLCA
             RLCA
             LD     (DUMP_A_BIN),A  ; GEM MEST BETYD NIBBLE I LOW

             INC    HL
             LD     A,(HL)
             CALL   CHK_ASCII       ; B=ASCII C=HEX A=OK ELLER TALLET
             CP     $FF             ; FEJL IKKE 0-9 ELLER A-F
             JP     Z,EDI_DU_FIND
             LD     A,B             ; OK FUNDET GODT TAL.
             LD     (DUMP_A_ASC+3),A  ; GEM 4. KARAK I ADRESSEN
             LD     A,(DUMP_A_BIN)  ; HENT MEST BETYD NIBBLE
             ADD    A,C             ; ADDER DE TO NIBBLER
             LD     (DUMP_A_BIN),A  ; GEM MEST BETYD BYTE
             LD     A,$FF
             LD     (DUMP_A_ASC+4),A  ; GEM 5. KARAK ER STOP

             LD     HL,DUMP_A_ASC
             CALL   TX_SER
             LD     HL,(DUMP_A_BIN) ; HER ER ADRESSEN MAN INDTASTEDE
             LD     A,(HL)          ; HENT DATA FRA ADRESSEN
             CALL   CONV_A2_ASC
             PUSH   HL
             LD     HL,DUMP_KARAK
             CALL   TX_SER
             POP    HL

             LD     A,','          ; KOMMA TIL INDTASTNING AF NY DATA
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.

             LD     B,'9'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'7'           ; LINJE ENER
             LD     E,'1'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC
             LD     A,1
             LD     (DEBUG_EDIT),A  ; ST EDIT DATA INPUT MODE
                                    ; TIL NSTE INDTASTNING
             CALL   SER_SLET
             JP     SERIAL_END



EDIT_DAT_IND:
             LD     HL,SER_STRING   ; HER STARTER START ADR.
             INC    HL
             LD     A,(HL)
             CALL   CHK_ASCII       ; B=ASCII C=HEX A=OK ELLER TALLET
             CP     $FF             ; FEJL IKKE 0-9 ELLER A-F
             JP     Z,EDIT_DAT_FEJL
             LD     A,C             ; OK FUNDET GODT TAL.
             SCF
             CCF
             RLCA
             RLCA
             RLCA
             RLCA
             LD     (EDIT_BIN),A    ; GEM MEST BETYD NIBBLE

             INC    HL
             LD     A,(HL)
             CALL   CHK_ASCII       ; B=ASCII C=HEX A=OK ELLER TALLET
             CP     $FF             ; FEJL IKKE 0-9 ELLER A-F
             JP     Z,EDIT_DAT_FEJL
             LD     A,(EDIT_BIN)    ; HENT MEST BETYD NIBBLE
             ADD    A,C             ; ADDER DE TO NIBBLER
             LD     (EDIT_BIN),A    ; GEM MEST BETYD BYTE

             LD     HL,(DUMP_A_BIN) ; ADRESSEN MAN VILLE NDRE.
             LD     (HL),A          ; SKRIV BYTEN MAN INDTASTEDE
EDIT_DAT_FEJL:                      ; VED FEJL I INPUT DATA, GEMMES DER IKKE
             CALL   SER_SLET

             LD     A,$0C          ; CLEAR SCREEN KODEN
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.

             LD     A,0
             LD     (DEBUG_EDIT),A ; AFSLUT EDIT DATA INPUT MODE
             JP     SER_DEBUG





SER_DUMP:    LD     B,'1'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'7'           ; LINJE ENER
             LD     E,'1'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC
             LD     HL,SER_STRING+1 ; HER STARTER START ADR.
SER_DU_FIND: INC    HL
             LD     A,(HL)
             CALL   CHK_ASCII       ; B=ASCII C=HEX A=OK ELLER TALLET
             CP     $FF             ; FEJL IKKE 0-9 ELLER A-F
             JP     Z,SER_DU_FIND
             LD     A,B             ; OK FUNDET GODT TAL.
             LD     (DUMP_A_ASC),A  ; GEM 1. KARAK I ADRESSEN
             LD     A,C             ; OK FUNDET GODT TAL.
             SCF
             CCF
             RLCA
             RLCA
             RLCA
             RLCA
             LD     (DUMP_A_BIN+1),A  ; GEM MEST BETYD NIBBLE

             INC    HL
             LD     A,(HL)
             CALL   CHK_ASCII       ; B=ASCII C=HEX A=OK ELLER TALLET
             CP     $FF             ; FEJL IKKE 0-9 ELLER A-F
             JP     Z,DUMP_1TAL
             LD     A,B             ; OK FUNDET GODT TAL.
             LD     (DUMP_A_ASC+1),A  ; GEM 2. KARAK I ADRESSEN
             LD     A,(DUMP_A_BIN+1)  ; HENT MEST BETYD NIBBLE
             ADD    A,C               ; ADDER DE TO NIBBLER
             LD     (DUMP_A_BIN+1),A  ; GEM MEST BETYD BYTE

DUMP_FUNDET: LD     A,'0'             ; OK FUNDET GODT TAL.
             LD     (DUMP_A_ASC+2),A  ; GEM 3. KARAK I ADRESSEN
             LD     (DUMP_A_ASC+3),A  ; GEM 4. KARAK I ADRESSEN
             LD     A,$FF
             LD     (DUMP_A_ASC+4),A  ; GEM 5. KARAK ER STOP
             LD     A,0
             LD     (DUMP_A_BIN),A   ;

             LD     HL,DUMP_A_ASC
             CALL   TX_SER
             LD     HL,(DUMP_A_BIN) ; HER ER ADRESSEN MAN INDTASTEDE

             LD     B,16            ; ANTAL LINJER
DUMPLINJER:  PUSH   BC              ; GEM ANTAL LINJER

             LD     B,16            ; ANTAL HEX TAL PR. LINJE
             LD     D,H
             LD     E,L             ; GEM START AF LINJE, TIL ASC-DUMP
DUMPLINE_HX: LD     A,(HL)          ; HENT DATA FRA ADRESSEN
             CALL   CONV_A2_ASC     ; KONVERT TIL ACSII, I 2 CIFRE
             PUSH   HL              ; GEM ADRESSE-DUMP TLLER
             LD     HL,DUMP_KARAK   ; PEG P ASCII, DER ER HEX TALLET KONV.
             CALL   TX_SER
             POP    HL              ; HENT ADRESSE-DUMP TLLER
             INC    HL              ; NSTE ADR.
             DJNZ   DUMPLINE_HX     ; DUMP IGEN, INDTIL DER ER SKREVET-
                                    ; 16 HEX TAL P LINJEN
             LD     B,3
             LD     A,' '
DUMP3SP:     CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
             DJNZ   DUMP3SP        ; 3 SPACES
             PUSH   HL
             LD     H,D
             LD     L,E            ; HENT START AF LINJEN

             LD     B,16           ; ANTAL ASCII DUMP PR. LINJE
DUMPLINEAS:  LD     A,(HL)
             JP     DUMP_CHECK
DUMP_UD:     CALL   TX_BUSY
             OUT    (UART0),A
             INC    HL
             DJNZ   DUMPLINEAS

             POP    HL             ; RESTORE HL TIL NSTE LINJE

             CALL   NYLINJE

             PUSH   HL
             LD     HL,DUMP_A_ASC+2  ; TIER ADR. ASCII
             LD     A,(HL)         ; DEN TLLER JO OP..
             INC    A
             CP     ':'            ; KARAKTER EFTER '9'
             JP     Z,DET_ER_A
             CP     'G'
             JP     Z,DET_ER_G
ALLE_ASCII:  LD     (HL),A

             LD     HL,DUMP_A_ASC
             CALL   TX_SER
DUMP_OVER:   POP    HL             ; RESTORE PEGER P ADR.

             POP    BC             ; HENT ANTAL LINJER
             DJNZ   DUMPLINJER

             LD     B,'1'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'5'           ; LINJE ENER
             LD     E,'1'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC
             LD     HL,TX_D_PROMPT  ; DEBUG PROMPT
             CALL   TX_SER
             LD     B,'2'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'5'           ; LINJE ENER
             LD     E,'1'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC

             CALL   SER_SLET
             JP     SERIAL_END

DET_ER_A:    LD     A,'A'
             JP     ALLE_ASCII
DET_ER_G:    LD     A,'F'
             JP     DUMP_OVER
DUMP_CHECK:  CP     $FF
             JP     Z,DUMP_SP
             CP     $00
             JP     Z,DUMP_SP
             CP     $05
             JP     Z,DUMP_SP
             CP     $07
             JP     Z,DUMP_SP
             CP     $08
             JP     Z,DUMP_SP
             CP     $09
             JP     Z,DUMP_SP
             CP     $0A
             JP     Z,DUMP_SP
             CP     $0B
             JP     Z,DUMP_SP
             CP     $0C
             JP     Z,DUMP_SP
             CP     $0D
             JP     Z,DUMP_SP
             CP     $13
             JP     Z,DUMP_SP
             CP     $14
             JP     Z,DUMP_SP
             CP     $15
             JP     NZ,DUMP_UD
DUMP_SP:     LD     A,'.'        ; DEN PRIK DER SKRIVES, NR DER ER DUM ASCII
             JP     DUMP_UD

DUMP_1TAL:   LD     A,'0'            ; HVIS MAN KUN TASTER 1 TAL, I ADRESSEN
             LD     (DUMP_A_ASC),A   ; VIL DEN VLGE ADR=0000
             LD     (DUMP_A_ASC+1),A
             LD     A,0
             LD     (DUMP_A_BIN+1),A
             JP     DUMP_FUNDET

SER_Q:       LD     A,0
             LD     (DEBUG),A      ; DEBUG ER NU AFSLUTTET
             CALL   SER_SLET
             LD     A,$0C          ; CLEAR SCREEN KODEN
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
             LD     B,'1'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'4'           ; LINJE ENER
             LD     E,'0'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC
             LD     HL,TX_PROMPT
             CALL   TX_SER
             LD     B,'4'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'4'           ; LINJE ENER
             LD     E,'0'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC
             JP     SERIAL_END


SER_SLET:    PUSH   HL       ; DENNE SUB, SLETTER DEN MODTAGNE STRING.
             PUSH   BC       ; FRA MODTAGE BUFFER P 20 BYTES.
             PUSH   AF
             LD     HL,SER_STRING
             LD     B,20           ; ANTAL KARAKTERE DER SKAL SLETTES
             LD     A,0
SER_SLETLP:  LD     (HL),A
             INC    HL
             DJNZ   SER_SLETLP
             LD     A,1
             LD     (SER_POINT),A  ; KLAR P 1. PLADS I BUFFER
             POP    AF
             POP    BC
             POP    HL
             RET


SER_COMPARE: LD     A,(BC) ; KENNY RULEZ!!!!!
             CP     $FF
             JP     Z,SER_COMP_OK
             CP     (HL)
             JP     NZ,SER_COMP_NO
             INC    HL
             INC    BC
             JP     SER_COMPARE
SER_COMP_NO: LD     A,0
SER_COMP_OK: RET


CONV_A2_ASC: PUSH   HL
             PUSH   BC
             PUSH   DE
             LD     B,A
             LD     HL,DUMP_KARAK
             LD     A,' '
             LD     (HL),A
             INC    HL
             LD     A,B
             RRCA                  ; A ER INPUT HEV TAL I 8 BIT
             RRCA                  ; HL PEGER P STED HVOR ASCII GEMMES
             RRCA                  ; FOR MESTE NIBBLE
             RRCA
             AND    $0F            ; ISOLER 4 LAVESTE BITS
             LD     D,A
             SUB    10             ; DEC ELLER HEX??
             JP     NC,CONV_HX
             LD     A,D
             ADD    A,$30
             JP     CONV_UD
CONV_HX:     ADD    A,$41
CONV_UD:     LD     (HL),A
             INC    HL
             LD     A,B            ; TALLET DER SKAL KONVERTERES
             AND    $0F            ; ISOLER 4 LAVESTE BITS
             LD     D,A            ; FOR LAVESTE NIBBLE
             SUB    10
             JP     NC,CONV_HX1
             LD     A,D
             ADD    A,$30
             JP     CONV_UD1
CONV_HX1:    ADD    A,$41
CONV_UD1:    LD     (HL),A
             INC    HL
             LD     A,$FF          ; STOP
             LD     (HL),A
             POP    DE
             POP    BC
             POP    HL
             RET

                             ; A=INPUT
CHK_ASCII:   CP     '0'      ; OUTPUT B=ASCII C=HEX (A=$FF FEJL, ELLER TALLET)
             JP     Z,CHK_0
             CP     '1'
             JP     Z,CHK_1
             CP     '2'
             JP     Z,CHK_2
             CP     '3'
             JP     Z,CHK_3
             CP     '4'
             JP     Z,CHK_4
             CP     '5'
             JP     Z,CHK_5
             CP     '6'
             JP     Z,CHK_6
             CP     '7'
             JP     Z,CHK_7
             CP     '8'
             JP     Z,CHK_8
             CP     '9'
             JP     Z,CHK_9
             CP     'A'
             JP     Z,CHK_A
             CP     'B'
             JP     Z,CHK_B
             CP     'C'
             JP     Z,CHK_C
             CP     'D'
             JP     Z,CHK_D
             CP     'E'
             JP     Z,CHK_E
             CP     'F'
             JP     Z,CHK_F
             CP     'a'
             JP     Z,CHK_A
             CP     'b'
             JP     Z,CHK_B
             CP     'c'
             JP     Z,CHK_C
             CP     'd'
             JP     Z,CHK_D
             CP     'e'
             JP     Z,CHK_E
             CP     'f'
             JP     Z,CHK_F
             LD     A,$FF
             RET
CHK_0:       LD     C,0
             LD     B,'0'
             RET
CHK_1:       LD     C,1
             LD     B,'1'
             RET
CHK_2:       LD     C,2
             LD     B,'2'
             RET
CHK_3:       LD     C,3
             LD     B,'3'
             RET
CHK_4:       LD     C,4
             LD     B,'4'
             RET
CHK_5:       LD     C,5
             LD     B,'5'
             RET
CHK_6:       LD     C,6
             LD     B,'6'
             RET
CHK_7:       LD     C,7
             LD     B,'7'
             RET
CHK_8:       LD     C,8
             LD     B,'8'
             RET
CHK_9:       LD     C,9
             LD     B,'9'
             RET
CHK_A:       LD     C,$A
             LD     B,'A'
             RET
CHK_B:       LD     C,$B
             LD     B,'B'
             RET
CHK_C:       LD     C,$C
             LD     B,'C'
             RET
CHK_D:       LD     C,$D
             LD     B,'D'
             RET
CHK_E:       LD     C,$E
             LD     B,'E'
             RET
CHK_F:       LD     C,$F
             LD     B,'F'
             RET





