;-------------------------

Set8	macro	?Register,?Value
	db	1,?Register,?Value
	endm
Set16	macro	?Register,?Value
	db	2,?Register
	dw	?Value
	endm
;----------------------------
;;default drive parametr block for  pc4104(4202496)
;PXLT=+1
;LXLT=+1
;DPB=72,4,15,0,2042,1023,255,255,256,2,2,3
;DPB=0x48,0x04,0x0F,0x00,0x7FA,0x3FF,0xFF,0xFF,0x100,0x02,0x00,0x00
;CSV=0x100
;ALV=0x100
;-------------------------
Magic	equ	0
DPB	equ	0x08
NDI	equ	0x20
DD	equ	0x80

	org	Magic
	db	"NDI-Z80E"


	org	DPB
	dw	72		;spt
	db	4		;bsh
	db	15		;blm
	db	0		;exm
	dw	2042		;dsm
	dw	1023		;drm
	db	0ffh		;al0
	db	0ffh		;al1
	dw	256		;cks
	dw	2		;off
	DB	0,0		;physical sector size and shift

eo$dpb
	rept	NDI-eo$dpb
	db	0
	endm

	org	NDI

	set8	080h,0		;order
	set8	081h,0		;formatType
	set8 	082h,0		;DONT use prepost

	set16	09ah,0		;IDM flag	0

	set16	0a0h,228	;Cylinders
	set8	0a1h,2		;Heads

	set8	0a3h,2		;density	(data) 	Double=2
	set16	0a4h,72		;SPT		(data) 
	set8	0a5h,0		;Sector Size	(data) 	128=0
	set8	0a6h,4		;clock		(data) 	3inch=4

	db	0ffh

eo$ndi
	rept	DD-eo$ndi
	db	0
	endm

eodd	equ	$

	end
;-------------------------