;-------------------------

Set8	macro	?Register,?Value
	db	1,?Register,?Value
	endm
Set16	macro	?Register,?Value
	db	2,?Register
	dw	?Value
	endm

;-------------------------
;PXLT=+1   LXLT=+1  
;DPB=72,5,31,1,2042,2047,255,255,512,2,2,3
;DPB=0x48,0x05,0x1F,0x01,0x7FA,0x7FF,0xFF,0xFF,0x200,0x02,0x00,0x00
;CSV=0x200
;ALV=0x100

Magic	equ	0
DPB	equ	0x08
NDI	equ	0x20
DD	equ	0x80

	org	Magic
	db	"NDI-Z80E"

	org	DPB
	dw	72		;spt
	db	5		;bsh
	db	31		;blm
	db	1		;exm
	dw	2042		;dsm
	dw	2047		;drm
	db	0ffh		;al0
	db	0ffh		;al1
	dw	512		;cks
	dw	2		;off
	DB	0,0		;physical sector size and shift

eo$dpb
	rept	NDI-eo$dpb
	db	0
	endm

	org	NDI

	set8	080h,0		;order
	set8	081h,0		;formatType
	set8 	082h,0		;DONT use prepost

	set16	09ah,0		;IDM flag	0

	set16	0a0h,455	;Cylinders
	set8	0a1h,2		;Heads

	set8	0a3h,2		;density	(data) 	Double=2
	set16	0a4h,72		;SPT		(data) 
	set8	0a5h,0		;Sector Size	(data) 	128=0
	set8	0a6h,4		;clock		(data) 	3inch=4

	db	0ffh
eo$ndi
	rept	DD-eo$ndi
	db	0
	endm

eodd	equ	$

	end
;-------------------------