#include "B:DATETIME.H"

struct	CPMfcb 
{
	uchar	dr;		/* drive/user code (0-15)*/
	char	name[8];	/* file name */
	char	ft[3];		/* file type */
	uchar	ex;		/* file extent 0-4*/
	char	bc;		/* byte count */
	char	exh;		/* file extent high 0-5*/
	char	rc;		/* number of records in present extent */
	char	dm[16];		/* CP/M disk map */
	char	nr;		/* next record to read or write */
	uchar	ranrec[3];	/* random record number (24 bit no. ) */
};
struct	CPMxfcb 
{
	uchar	dr;		/* drive/user code (user no + 16)*/
	char	name[8];	/* file name */
	char	ft[3];		/* file type */
	uchar	pm;		/* password mode byte */
				/* RWDx xxxx */
	uchar	pd;		/* Password decode xor reverse */
	char	fil[2];		/* not used */
	char	pw[8];		/* CP/M password */
	char	resv[8];	/* CP/M reserved */
};
struct	CPMfcbLabel 
{
	uchar		dr;		/* drive/user code (32 020h)*/
	char		name[8];	/* file name */
	char		ft[3];		/* file type */
	uchar		dl;		/* label data byte */
					/* PAUC xxxD */
	uchar		pd;		/* Password decode xor reverse */
	char		fil[2];		/* not used */
	char		pw[8];		/* CP/M password */
	struct DTS	ACdts;		/* create TS */
	struct DTS	Udts;		/* update TS */
};
/* FCBLAB.ACdts.Date */
struct fcbStamps
{
	struct DTS 	ACdts;
	struct DTS	Udts;
	uchar		PM;		/* Password mode */
	uchar		resv;

};
struct CPMsfcb
{
	uchar			dr;	/* drive/user code (33 021h)*/
	struct fcbStamps	Stamps[3];
	uchar			resv;
};
/* SFCB.Stamps[0].ACdts.Date */

struct CPMdpb
{
	short SPT;
	uchar BSH;
	uchar BLM;
	uchar EXM;
	short DSM;
	short DRM;
	uchar AL0;
	uchar AL1;
	short CKS;
	short OFF;
	uchar PSH;
	uchar PHM;
};
struct DirectBios
{
	uchar	Func;
	uchar	A;
	ushort	BC;
	ushort	DE;
	ushort	HL;
};
struct RegisterSet
{
	uchar	PSW;
	uchar	A;
	ushort	BC;
	ushort	DE;
	ushort	HL;
};
struct DPH2
{
	ushort	XLT;
	ushort	Resv[3];
	ushort	DIRBUF;
	ushort	DPB; /* +10 */
	ushort	CSV;
	ushort	ALV;
};
struct DPH3
{
	ushort	XLT;
	uchar	Resv[9];
	uchar	MF;
	ushort	DPB; /* +12 */
	ushort	CSV;
	ushort	ALV;
	ushort	DIRBCB;
	ushort	DTABCB;
	ushort	HASH;
	uchar	HBANK;
};
