	maclib	z80
	
nk$sys	equ	62		;system size in  kBytes
td	equ	nk$sys/10	;decimal tens digit
od	equ	nk$sys mod 10	;decimal ones digit
td$asc	equ	td+030h		;ascci tens digit
od$asc	equ	od+030h		;ascii ones digit
k$byte	equ	1024		;bytes in a kilobyte
cpm$sz	equ	nk$sys*k$byte	;top system addres
v$20k	equ	20*k$byte	;twenty kByte 
cpm$bs	equ	cpm$sz-v$20k	;cpm bias value

ccp	equ	cpm$bs+03400h	;addres of ccp
bdos	equ	cpm$bs+03c00h	;addres of bdos
bios	equ	cpm$bs+04a00h	;addres of bios
tpa	equ	0100h		;addres of TPA

c$disk	equ	4		;address of current logged disk
err$sts	equ	8

dsk$cmd equ 0D0h 
dsk$sts equ 0D0h 
dsk$drv		equ	0D1h ;drv
dsk$trkL	equ	0D2h ;trkLow
dsk$trkH	equ	0D3h ;trkHigh
dsk$secL	equ	0D4h ;secLow
dsk$secH	equ	0D5h ;secHigh
dsk$dmaL	equ	0D6h ;dmaLow
dsk$dmaH	equ	0D7h ;dmaHigh
dsk$sptL	equ	0D8h ;sptLow
dsk$sptH	equ	0D9h ;sptHigh

cmd$read	equ	1
cmd$write	equ	2
cmd$log		equ	4
cmd$fmt		equ	8

sec$sz	equ	128

	org	tpa
; this move is for CPM 3.0
; It allows CPMLDR to run at 0100h

	mvi	a,01h	; s =0100h
	out	0e5h	; source high
	mvi	a,31h	; s =3100h
	out	0e7h	; dest high
	mvi	a,00h
	out	0e4h	; source low
	out	0e6h	; dest low
	mvi	a,080h	;move 128 bytes
	out	0e8h	; count low
	mvi	a,00h	; move 128 bytes
	out	0e9h	; count high
	; cmd=move s to d, but only to/from common, above boundary
	mvi	a,04h	
	out	0e0h	; single thread, no need to wait
	jmp	diskrd+3000h	;jmp to new copy

; this is position in dependent
diskrd:
	mvi	a,0		;sel drive
	out	dsk$drv
	mvi	a,0		;sel Track
	out	dsk$trkL
	mvi	a,17		;sel Sector
	out	dsk$secL
	mvi	a,low tpa		;setdma=0100
	out	dsk$dmaL
	mvi	a,high tpa
	out	dsk$dmaH
read$sec:
	mvi	a,cmd$read	;read
	out	dsk$cmd
	in	dsk$sts
	ana	a		;set flags(ccr)
	jrnz	r$eror	;exit if error
	in	dsk$secL	;get sector number
	cpi	72		;rest of track
	jz	tpa		;exit to BIOS
	inr	a		;next sector
	out	dsk$secL	;store next sector
	lxi	d,sec$sz	;sector size
	in	dsk$dmaL
	mov	l,a
	in	dsk$dmaH
	mov	h,a
	dad	d		;new buffer address 
	mov	a,l
	out	dsk$dmaL
	mov	a,h
	out	dsk$dmaH
	jr	read$sec		;again 

r$eror:	 sta	err$sts		;store error 
	 hlt			;halt

