;only need 6 tracks to test
; add this binary file to the beginnning of a BLANK disk image
;  DD.EXE IF=disk.bin OF=disk.img
; this generates a disk with some sectors at the begining filled with ID info
; it is for testing to see what tracks and sectors are accessed
; dont try to make more than 64k, the assembler can not do more

SSSD26$128	equ	0
DSSD26$128	equ	1

SSDD26$256	equ	8
DSDD26$256	equ	9

SSSD18$128	equ	2
DSSD18$128	equ	3

SSDD50$128	equ	4
DSDD50$128	equ	5

SSDD29$128	equ	6
DSDD29$128	equ	7

AppleII16$256	equ	8

DSDD72$128	equ	0x10

;DISK	equ	SSSD26$128
DISK	equ	AppleII16$256

	nolist
	if 	DISK=AppleII16$256
SPT	equ	16	;apple  
SIDES 	equ	1	;for DS
CYLS	equ	3	;for SS
SECTSZ	equ	256	
	endif
	if 	DISK=SSSD26$128
SPT	equ	26	;ibm26  
SIDES 	equ	1	;for SS
CYLS	equ	6	;for SS
SECTSZ	equ	128	
	endif
	if 	DISK=DSSD26$128
SPT	equ	26	;ibm26  
SIDES 	equ	2	;for DS
CYLS	equ	3	;for SS
SECTSZ	equ	128	
	endif
	if 	DISK=SSDD26$256
SPT	equ	26	;ibm26  
SIDES 	equ	1	;for SS
CYLS	equ	6	;for SS
SECTSZ	equ	256
	endif
	if 	DISK=DSDD26$256
SPT	equ	26	;ibm26  
SIDES 	equ	2	;for DS
CYLS	equ	3	;for SS
SECTSZ	equ	256
	endif

	if 	DISK=SSDD50$128
SPT	equ	50	;ibm26  
SIDES 	equ	1	;for SS
CYLS	equ	6	;for SS
SECTSZ	equ	128
	endif
	if 	DISK=DSDD50$128
SPT	equ	50	;ibm26  
SIDES 	equ	2	;for DS
CYLS	equ	3	;for SS
SECTSZ	equ	128
	endif

	if 	DISK=SSSD18$128
SPT	equ	18	;mini18	
SIDES 	equ	1	;for DS
CYLS	equ	6	;for DS  
SECTSZ	equ	128	
	endif

	if 	DISK=DSSD18$128
SPT	equ	18	;mini18	
SIDES 	equ	2	;for DS
CYLS	equ	3	;for DS  
SECTSZ	equ	128	
	endif

	if 	DISK=SSDD29$128
SPT	equ	29	;mini29 
SIDES 	equ	1	;for DS
CYLS	equ	6	;for DS  
SECTSZ	equ	128	
	endif

	if 	DISK=DSDD29$128
SPT	equ	29	;mini29 
SIDES 	equ	2	;for DS
CYLS	equ	3	;for DS  
SECTSZ	equ	128	
	endif

	if 	DISK=DSDD72$128
SPT	equ	72	;pc1440 
SIDES 	equ	2	;for DS
CYLS	equ	3	;for DS  
SECTSZ	equ	128	
	endif

;SECTSZ	equ	512
;SECTSZ	equ	1024

count	set	0


cyl	set	0
	rept	CYLS
side	set	0
	rept	SIDES
sector	set	1
	rept	SPT
	org	count
track	set	(cyl * SIDES)+side
	db	"vvv"
	list
	db	cyl,"v",side,"v",track,"v",sector
	nolist
	db	"vvvvvv"
	org	count +16
	db	"Cylinder - "
	db	cyl / 10 + '0'
	db	cyl mod 10 + '0'
	org	count +32
	db	"Side - "
	db	side / 10 + '0'
	db	side mod 10 + '0'
	org	count +48
	db	"Track - "
	db	track / 10 + '0'
	db	track mod 10 + '0'
	org	count +64
	db	"Sector - "
	db	sector / 10 +'0'
	db	sector mod 10 +'0'
	org	count +80
	db	"S"
	db	SIDES / 10 +'0'
	db	SIDES mod 10 +'0'
	db	" SPT"
	db	SPT / 10 +'0'
	db	SPT mod 10 +'0'
	db	" Sz"
	db	SECTSZ / 100 +'0'
	db	(SECTSZ % 100) / 10 +'0'
	db	SECTSZ mod 10 +'0'
	org	count+(SECTSZ-16)
	db	0x5e,0x5e,0x5e,0x5e,0x5e,0x5e,0x5e,0x5e,0x5e,0x5e,0x5e,0x5e,0x5e,0x5e,0x5e,0x5e
sector	set	sector+1
count 	set 	count+SECTSZ
	endm
side	set	side+1
	endm
cyl	set	cyl+1
	endm

	end

