	z80

;Default IOBYTE is 10000000b 
;LST:=lpt PUN:=tty RDR:=tty CON:=tty

;tty: is Emulated terminal
;crt: is Emulated CRT
;bat: is RDR: for input and LST: for output.
;uc1: is Serial A
 
;lpt: is Emulated printer
;ul1: is serial B

;ptp: is Emulated printer
;ptr: is Eternal File System
;up1: is serial A
;ur1: is serial A
;up2: is serial B
;ur2: is serial B


true	equ	0ffh
false	equ	0

nk.sys	equ	62	;system size in K
kdb	equ	1024	;1k
hkdb	equ	kdb/2	;half k
cpm.sz	equ	nk.sys*kdb	;top sys address
td	equ	nk.sys/10	;decimal tens digit
od	equ	nk.sys%10	;decimal ones digit
td.asc	equ	td+&h30		;ascci tens digit
od.asc	equ	od+&h30		;ascii ones digit
bias	equ	20*kdb		;20k
cpm.bs	equ	cpm.sz-bias	;cpm size
ccp	equ	cpm.bs+3400h	;address of ccp
bdos	equ	cpm.bs+3c00h	;address of bdos
bios	equ	cpm.bs+4a00h	;address of bios
xbios	equ	bios+kdb	;
tpa	equ	100h		;tpa

;      	LST: 	PUN:	RDR:	CON:	
;	10	00	00	00
;------------------------------------
;00	tty:	tty:	tty:	tty:
;01	crt:	ptp:	ptr:	crt:
;10	lpt:	up1:	ur1:	bat:
;11	ul1:	up2:	ur2:	uc1:

df.iob	equ	10000000b	;def iobyte	
iobyte	equ	3		;addres of iobyte

lb.con	equ	4fh		;last byte entered through con
ll.drv	equ	4		;address of last logged drive
df.drv	equ	0		;def drive =a
sec.sz	equ	080h		;sector size
fmt.sz	equ	0100h		;format buffer size
n.drvs	equ	4		;number of drives1-4

	org	xbios		;end of bios

	jmp	cold		;cold start		0

	jmp	init		;reinitialize		3

	jmp	warm		;warm start		6	3
	jmp	cns.ci		;console input status	9	6
	jmp	cns.in		;console input		c	9
	jmp	cns.ot		;console output		f	c
	jmp	lst.ot		;list output		12	f
	jmp	pch.ot		;punch output		15	12
	jmp	rdr.in		;reader input		18	15
	jmp	lst.co		;list output status	1b	2D

	jmp	msg.ot		;message output		
	jmp	cns.co		;console output status
	jmp	pch.co		;punch output status
	jmp	rdr.ci		;reader input status

; variables

old.warm	dw	0


cls	equ	1c7eh		;clear screen for h1510

msg.so	db	cr,lf		;newline
	text	"Extended Bios "
sys.td	db	td.asc		;tens digit
sys.od	db	od.asc		;ones digit
	text	"K"
	db	cr,lf,lf	;sign bit set on last byte
	db	'$'


bell	equ	07h		;beep
msg.wm	db	bell		;beep
	db	'$'
;init

cold
	lhld	bios+4		;old bios WARM vector
	shld	old.warm	;is saved	

	lxi	h,xbios+06h	;new warm vector
	shld	bios+04h	;bios warm vector
	lxi	h,xbios+09h	;new console check vector
	shld	bios+07h	;bios console check vector
	lxi	h,xbios+0cH	;new console in vector
	shld	bios+0ah	;bios console in vector
	lxi	h,xbios+0fH	;new console out vector
	shld	bios+0dh	;bios console out vector
	lxi	h,xbios+012H	;new list out vector
	shld	bios+10h	;bios list out vector
	lxi	h,xbios+015H	;new punch out vector
	shld	bios+13h	;bios punch out vector
	lxi	h,xbios+18H	;new reader in vector
	shld	bios+16h	;bios reader in vector
	lxi	h,xbios+1BH	;new list status vector
	shld	bios+2eh	;bios list status vector


init
	mvi	a,df.iob	;default iobyte
	sta	iobyte		;


c.logo	lxi	h,msg.so	;sign on message
	call	msg.ot		;issue message
;	ret			;return to caller

;warm
	
warm	lxi	h,msg.wm	;warm msg
	call	msg.ot		;issue msg
	lhld	old.warm	;
	push	hl		;put on stack
	ret			;ret 

;console check input status

cns.ci	lda	iobyte		;
	ani	00000011b	;
	jz	tty.ci		;
	dcr	a		;
	jz	crt.ci		;
	dcr	a		;
	jz	bat.ci		;
	jmp	uc1.ci		;

;console input


cns.in	lda	iobyte		;
	ani	00000011b	;
	jz	tty.in		;
	dcr	a		;
	jz	crt.in		;
	dcr	a		;
	jz	bat.in		;
	jmp	uc1.in		;

;console output

cns.ot	lda	iobyte		;
	ani	00000011b	;
	jz	tty.ot		;
	dcr	a		;
	jz	crt.ot		;
	dcr	a		;
	jz	bat.ot		;
	jmp	uc1.ot		;

;console check output status

cns.co	lda	iobyte		;
	ani	00000011b	;
	jz	tty.co		;
	dcr	a		;
	jz	crt.co		;
	dcr	a		;
	jz	bat.co		;
	jmp	uc1.co		;

;reader check input status

rdr.ci	lda	iobyte		;
	ani	00001100b	;
	rrc
	rrc
	jz	tty.ci		;
	dcr	a		;
	jz	ptr.ci		;
	dcr	a		;
	jz	ur1.ci		;
	jmp	ur2.ci		;

;reader  input 

rdr.in	lda	iobyte		;
	ani	00001100b	;
	rrc
	rrc
	jz	tty.in		;
	dcr	a		;
	jz	ptr.in		;
	dcr	a		;
	jz	ur1.in		;
	jmp	ur2.in		;

;punch  output 

pch.ot	lda	iobyte		;
	ani	00110000b	;
	rrc			;
	rrc			;
	rrc			;
	rrc			;
	jz	tty.ot		;
	dcr	a		;
	jz	ptp.ot		;
	dcr	a		;
	jz	up1.ot		;
	jmp	up2.ot		;
;punch check output status

pch.co	lda	iobyte		;
	ani	00110000b	;
	rrc			;
	rrc			;
	rrc			;
	rrc			;
	jz	tty.co		;
	dcr	a		;
	jz	ptp.co		;
	dcr	a		;
	jz	up1.co		;
	jmp	up2.co		;

;list output 

lst.ot	lda	iobyte		;
	ani	11000000b	;
	rrc			;
	rrc			;
	rrc			;
	rrc			;
	rrc			;
	rrc			;
	jz	tty.ot		;
	dcr	a		;
	jz	crt.ot		;
	dcr	a		;
	jz	lpt.ot		;
	jmp	ul1.ot		;
;list check output status

lst.co	lda	iobyte		;
	ani	11000000b	;
	rrc			;
	rrc			;
	rrc			;
	rrc			;
	rrc			;
	rrc			;
	jz	tty.co		;
	dcr	a		;
	jz	crt.co		;
	dcr	a		;
	jz	lpt.co		;
	jmp	ul1.co		;


;eXternal File Sysytem

xfi.sp	equ	0a1h		;input status port
xfi.sb	equ	001h		;0=no more bytes(eof) 1=a byte is available
xfi.si	equ	0		;input status invert
xfi.dp	equ	0a0h		;input data port

xfo.sp	equ	0a3h		;output status port
xfo.sb	equ	001h		;status - 0=no file open(eof) 1=OK
xfo.si	equ	0		;output status invert
xfo.dp	equ	0a2h		;output data port

xfs.ci	mvi	a,0ffh		;ready
	ret			;	

xfs.eof	mvi	a,cntl.z	;end of file
	ret			;

xfs.in  in	xfi.sp
	ani	xfi.sb
	jrz	xfs.eof
	in	xfi.dp
	ani	07fh		;make ascci
	ret

;Emulated Terminal

cni.sp	equ	07dh		;input status port
cni.sb	equ	002h		;input status bit
cni.si	equ	0		;input status invert
cni.dp	equ	07ch		;input data port

cno.sp	equ	07dh		;output status port
cno.sb	equ	001h		;output status bit
cno.si	equ	0		;output status invert
cno.dp	equ	07ch		;output data port


;tty - masks input and output char to 8 bit ascii

tty.in	call	tty.ci		;check status
	jrz	tty.in
	in	cni.dp
;	ani	07fh		;make ascci
	ret

tty.ci	in	cni.sp
	ani	cni.sb
	rz
	mvi	a,0ffh
	ret

tty.ot	call	tty.co		;check status
	jrz	tty.ot		;repeat until ready
	mov	a,c		;get char
;	ani	07fh		;make ascci
	out	cno.dp		;out to data port
	ret

tty.co	in	cno.sp		;status port
	ani	cno.sb		;check status bit
	rz			;
	mvi	a,0ffh		;
	ret

;Emulated CRT

cti.sp	equ	07bh		;input status port
cti.sb	equ	002h		;input status bit
cti.si	equ	0		;input status invert
cti.dp	equ	07ah		;input data port

cto.sp	equ	07bh		;output status port
cto.sb	equ	001h		;output status bit
cto.si	equ	0		;output status invert
cto.dp	equ	07ah		;output data port
;crt - masks input char to 8 bit ascii From CRT

crt.ci	in	cti.sp
	ani	cti.sb
	rz
	mvi	a,0ffh
	ret	

crt.in call	crt.ci		;check status
	jrz	crt.in
	in	cti.dp
;	ani	07fh		;make ascci
	ret

;crt check output

crt.co	in	cto.sp		;status port
	ani	cto.sb		;check status bit
	rz			;
	mvi	a,0ffh		;
	ret

crt.ot	call	crt.co		;check status
	jrz	crt.ot		;repeat until ready
	mov	a,c		;get char
;	ani	07fh		;make ascci
	out	cto.dp		;out to data port
	ret

;user console 1 - inputs and outputs 8 bit ascii to Serial A

uc1.in	jmp	srA.in
uc1.ci	jmp	srA.ci

uc1.ot	jmp	srA.ot
uc1.co	jmp	srA.co

;Serial A - inputs and outputs 8 bit ascii to Serial A
;

sAi.sp	equ	071h		;input status port
sAi.sb	equ	002h		;input status bit
sAi.si	equ	0		;input status invert
sAi.dp	equ	070h		;input data port

sAo.sp	equ	071h		;output status port
sAo.sb	equ	001h		;output status bit
sAo.si	equ	0		;output status invert
sAo.dp	equ	070h		;output data port

srA.in	call	srA.ci		;check status
	jrz	srA.in
	in	sAi.dp
	ret

srA.ci	in	sAi.sp
	ani	sAi.sb
	rz
	mvi	a,0ffh
	ret

srA.ot	call	srA.co		;check status
	jrz	srA.ot		;repeat until ready
	mov	a,c		;get char
	out	sAo.dp		;out to data port
	ret

srA.co	in	sAo.sp		;status port
	ani	sAo.sb		;check status bit
	rz			;
	mvi	a,0ffh		;
	ret

;Serial B - inputs and outputs 8 bit ascii to Serial B
;for Serial B port

sBi.sp	equ	073h		;input status port
sBi.sb	equ	002h		;input status bit
sBi.si	equ	0		;input status invert
sBi.dp	equ	072h		;input data port

sBo.sp	equ	073h		;output status port
sBo.sb	equ	001h		;output status bit
sBo.si	equ	0		;output status invert
sBo.dp	equ	072h		;output data port

srB.in	call	srB.ci		;check status
	jrz	srB.in
	in	sBi.dp
	ret

srB.ci	in	sBi.sp
	ani	sBi.sb
	rz
	mvi	a,0ffh
	ret

srB.ot	call	srB.co		;check status
	jrz	srB.ot		;repeat until ready
	mov	a,c		;get char
	out	sBo.dp		;out to data port
	ret

srB.co	in	sBo.sp		;status port
	ani	sBo.sb		;check status bit
	rz			;
	mvi	a,0ffh		;
	ret

;batch current rdr is input, current lst is output

bat.in	jmp	rdr.in
bat.ci	jmp	rdr.ci
bat.ot	jmp	lst.ot
bat.co	jmp	lst.co

;null devices

nul.in	mvi	a,cntl.z	;end of file
	ret			;

nul.ci	mvi	a,0ffh		;ready
	ret			;	

nul.ot	ret			;bit bucket

nul.co	mvi	a,0ffh		;ready
	ret

;reader and punch

ptr.in	jmp 	xfs.in
ptr.ci	jmp	xfs.ci		;	

ptp.ot	jmp	lpt.ot
ptp.co	jmp	lpt.co

;user readers and punches

ur1.in	jmp	srA.in
ur1.ci	jmp	srA.ci

up1.ot	jmp	srA.ot
up1.co	jmp	srA.co


ur2.in	jmp	srB.in
ur2.ci	jmp	srB.ci

up2.ot	jmp	srB.ot
up2.co	jmp	srB.co

; user list 1 printer driver to Serial B

ul1.ot	jmp	srB.ot
ul1.co	jmp 	srB.co

;printer driver

lst.dp	equ	07eH		;list data port
lst.st	equ	07fH		;list status port
lst.ctl	equ	lst.st		;control port
lst.msk	equ	00000001B	;status mask (ORPLY)
ctl.msk	equ	00000001b	;control mask (OSTB)
mem.msk	equ	00000010b	;sbc mem mask 10=out 00=in

lpt.co	in	lst.st		;
;	cma			;
	ani	lst.msk		;
	rz			;not ready
	mvi	a,&Hff		;ready
	ret
	
lpt.ot	call	lpt.co		;get status
	jrz	lpt.ot		;wait for ready
	mov	a,c		;get char from c
	out	lst.dp		;out char to data port
	mvi	a,ctl.msk		;strobe data
	out	lst.ctl		;strobe
	ret			;return

;display string

msg.ot	push	psw		;save ccr and a
..rept	mov	a,m		;get char fron where hl points
	cpi	'$'		;until dollar sign 
	jrz	msg.ret
	mov	c,a
	call	cns.ot		;output char
	inx	hl		;inc to next char
	jr	..rept		;repeat 
msg.ret	pop	psw		;restore ccr and a
	ret			;;return

;io definitions

lf	equ	0ah		;line feed
cr	equ	0dh		;carrige return
cntl.z	equ	1ah		;control z(eof)

eoxbios	equ	$
	end